/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.reference.resolve.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.function.Function;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.reference.resolve.validate.TypeValidator;
import org.indunet.fastproto.reference.resolve.validate.ValidatorContext;

public class FieldValidator
extends TypeValidator {
    @Override
    public void process(ValidatorContext context) {
        ProtocolType protocolType = context.getProtocolType();
        Class<? extends Annotation> typeAnnotationClass = context.getTypeAnnotationClass();
        Field field = context.getField();
        Class<? extends Function<?, ?>> decodingFormula = null;
        Class<? extends Function<?, ?>> encodingFormula = null;
        try {
            if (protocolType.decodingFormula().length > 0) {
                decodingFormula = protocolType.decodingFormula()[0];
            }
            if (protocolType.encodingFormula().length > 0) {
                encodingFormula = protocolType.encodingFormula()[0];
            }
            context.setDecodingFormula(decodingFormula);
            context.setEncodingFormula(encodingFormula);
        }
        catch (Exception e) {
            throw new DecodeFormulaException(MessageFormat.format(CodecError.FAIL_GETTING_DECODE_FORMULA.getMessage(), protocolType.getType().getName(), field.getName()), (Throwable)e);
        }
        this.forward(context);
    }
}

