/*
 * Copyright 2019-2021 indunet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.indunet.fastproto.pipeline.encode;

import lombok.val;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;
import org.indunet.fastproto.pipeline.FlowCode;

/**
 * Compress flow.
 *
 * @author Deng Ran
 * @since 1.7.0
 */
public class CompressFlow extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        boolean enableCompress =
                    (context.getCodecFeature() & CodecFeature.DISABLE_COMPRESS) == 0;
        Class<?> protocolClass = context.getProtocolClass();
        byte[] datagram = context.getDatagram();

        if (enableCompress && protocolClass.isAnnotationPresent(EnableCompress.class)) {
            val annotation = protocolClass.getAnnotation(EnableCompress.class);
            val compressor = Compressor.getInstance(annotation);

            context.setDatagram(compressor.compress(datagram));
        }

        this.forward(context);
    }

    @Override
    public long getCode() {
        return FlowCode.COMPRESS_FLOW_CODE;
    }
}
