/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BoolType;
import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Int16Type;
import org.indunet.fastproto.annotation.type.Int32Type;
import org.indunet.fastproto.annotation.type.Int64Type;
import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.annotation.type.UInt16Type;
import org.indunet.fastproto.annotation.type.UInt32Type;
import org.indunet.fastproto.annotation.type.UInt64Type;
import org.indunet.fastproto.annotation.type.UInt8Type;

public interface ProtocolType {
    public static final Class<? extends Annotation> BINARY = BinaryType.class;
    public static final Class<? extends Annotation> BOOL = BoolType.class;
    public static final Class<? extends Annotation> CHAR = CharType.class;
    public static final Class<? extends Annotation> DOUBLE = DoubleType.class;
    public static final Class<? extends Annotation> FLOAT = FloatType.class;
    public static final Class<? extends Annotation> INT32 = Int32Type.class;
    public static final Class<? extends Annotation> INT64 = Int64Type.class;
    public static final Class<? extends Annotation> STRING = StringType.class;
    public static final Class<? extends Annotation> TIME = TimeType.class;
    public static final Class<? extends Annotation> INT8 = Int8Type.class;
    public static final Class<? extends Annotation> INT16 = Int16Type.class;
    public static final Class<? extends Annotation> UINT8 = UInt8Type.class;
    public static final Class<? extends Annotation> UINT16 = UInt16Type.class;
    public static final Class<? extends Annotation> UINT32 = UInt32Type.class;
    public static final Class<? extends Annotation> UINT64 = UInt64Type.class;
    public static final Class<? extends Annotation> ENUM = EnumType.class;

    public static ProtocolType proxy(Annotation typeAnnotation) {
        return (ProtocolType)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{ProtocolType.class, typeAnnotation.annotationType()}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "getType": {
                    return typeAnnotation.annotationType();
                }
                case "size": {
                    try {
                        return typeAnnotation.annotationType().getDeclaredField("SIZE").getInt(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return 0;
                    }
                }
                case "length": {
                    if (!Arrays.stream(typeAnnotation.getClass().getMethods()).noneMatch(m -> m.getName().equals("length"))) break;
                    return 0;
                }
            }
            if (typeAnnotation.annotationType() == BoolType.class && method.getName().equals("offset")) {
                return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals("byteOffset")).findAny().get().invoke((Object)typeAnnotation, args);
            }
            return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get().invoke((Object)typeAnnotation, args);
        });
    }

    public int offset();

    public int byteOffset();

    public int bitOffset();

    public int length();

    public String field();

    public EndianPolicy[] endianPolicy();

    public Class<? extends Annotation> getType();

    public int size();
}

