/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class EnumCodec<T extends Enum>
implements Codec<T> {
    public T decode(@NonNull byte[] bytes, int offset, String fieldName, Class<T> enumClass) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        int code = CodecUtils.uint8Type(bytes, offset);
        if (fieldName == null || fieldName.isEmpty()) {
            return (T)Arrays.stream(enums).filter(e -> e.ordinal() == code).findAny().orElseThrow(() -> new DecodingException(MessageFormat.format(CodecError.ENUM_NOT_FOUND.getMessage(), code)));
        }
        Function<Enum, Integer> getValue = enumObject -> {
            Field field = null;
            try {
                field = enumClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.getInt(enumObject);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new DecodingException(MessageFormat.format(CodecError.ILLEGAL_ENUM_CODE_FIELD.getMessage(), fieldName), (Throwable)e);
            }
        };
        return (T)Arrays.stream(enums).filter(e -> (Integer)getValue.apply((Enum)e) == code).findAny().orElseThrow(() -> new DecodingException(MessageFormat.format(CodecError.ENUM_NOT_FOUND.getMessage(), code)));
    }

    public <T extends Enum> void encode(byte[] bytes, int offset, String fieldName, T value) {
        int code = 0;
        if (fieldName == null || fieldName.isEmpty()) {
            code = value.ordinal();
        } else {
            try {
                Field field = value.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                code = field.getInt(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new EncodingException(MessageFormat.format(CodecError.ILLEGAL_ENUM_CODE_FIELD.getMessage(), fieldName), (Throwable)e);
            }
        }
        CodecUtils.uint8Type(bytes, offset, code);
    }

    @Override
    public T decode(CodecContext context, byte[] bytes) {
        EnumType dataType = context.getDataTypeAnnotation(EnumType.class);
        Class<?> fieldType = context.getFieldType();
        return (T)this.decode(bytes, dataType.offset(), dataType.name(), fieldType);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, T value) {
        EnumType dataType = context.getDataTypeAnnotation(EnumType.class);
        this.encode(bytes, dataType.offset(), dataType.name(), value);
    }
}

