/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class FloatCodec
implements Codec<Float> {
    public float decode(byte[] bytes, int offset, EndianPolicy endian) {
        try {
            return CodecUtils.floatType(bytes, offset, endian);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding float type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, float value) {
        try {
            CodecUtils.floatType(bytes, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding float type.", (Throwable)e);
        }
    }

    @Override
    public Float decode(CodecContext context, byte[] bytes) {
        FloatType type = context.getDataTypeAnnotation(FloatType.class);
        EndianPolicy policy = context.getEndianPolicy();
        return Float.valueOf(this.decode(bytes, type.offset(), policy));
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Float value) {
        FloatType type = context.getDataTypeAnnotation(FloatType.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value.floatValue());
    }
}

