/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.time.Instant;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class InstantCodec
implements Codec<Instant> {
    public Instant decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, policy);
            return Instant.ofEpochMilli(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(instant) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, Instant value) {
        try {
            long millis = value.toEpochMilli();
            CodecUtils.int64Type(bytes, offset, policy, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(instant) type.", (Throwable)e);
        }
    }

    @Override
    public Instant decode(CodecContext context, byte[] bytes) {
        EndianPolicy policy = context.getEndianPolicy();
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Instant value) {
        EndianPolicy policy = context.getEndianPolicy();
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        this.encode(bytes, type.offset(), policy, value);
    }
}

