/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInt16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt16Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            return CodecUtils.uint16Type(bytes, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint16 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, int value) {
        try {
            CodecUtils.uint16Type(bytes, offset, policy, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint16 type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        UInt16Type type = context.getDataTypeAnnotation(UInt16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        UInt16Type type = context.getDataTypeAnnotation(UInt16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

