/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.compress.DeflateCompressor;
import org.indunet.fastproto.compress.GzipCompressor;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CompressException;

public interface Compressor {
    public byte[] compress(byte[] var1);

    public byte[] uncompress(byte[] var1);

    public static Compressor getInstance(EnableCompress enableCompress) {
        switch (enableCompress.value()) {
            case GZIP: {
                return GzipCompressor.getInstance();
            }
            case DEFLATE: {
                return DeflateCompressor.getInstance(enableCompress.level());
            }
        }
        throw new CompressException(CodecError.INVALID_COMPRESS_POLICY);
    }
}

