/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.NonNull;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CompressException;

public class GzipCompressor
implements Compressor {
    protected static final GzipCompressor compressor = new GzipCompressor();

    protected GzipCompressor() {
    }

    public static GzipCompressor getInstance() {
        return compressor;
    }

    @Override
    public byte[] compress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(bytes);
        }
        catch (IOException e) {
            throw new CompressException(MessageFormat.format(CodecError.FAIL_COMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] uncompress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try (GZIPInputStream ungzip = new GZIPInputStream(in);){
            byte[] buffer = new byte[256];
            int n = 0;
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new CompressException(MessageFormat.format(CodecError.FAIL_UNCOMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
        return out.toByteArray();
    }
}

