/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.io.IOException;
import java.text.MessageFormat;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CompressException;
import org.xerial.snappy.Snappy;

public class SnappyCompressor
implements Compressor {
    @Override
    public byte[] compress(byte[] bytes) {
        try {
            return Snappy.compress((byte[])bytes);
        }
        catch (IOException e) {
            throw new CompressException(MessageFormat.format(CodecError.FAIL_COMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public byte[] uncompress(byte[] bytes) {
        try {
            return Snappy.uncompress((byte[])bytes);
        }
        catch (IOException e) {
            throw new CompressException(MessageFormat.format(CodecError.FAIL_UNCOMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
    }
}

