/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.text.MessageFormat;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.codec.CodecFactory;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        CodecContext context = CodecContext.builder().dataTypeAnnotation(reference.getDataTypeAnnotation()).fieldType(reference.getField().getType()).endianPolicy(reference.getEndianPolicy()).build();
        reference.setDecoder(CodecFactory.createDecoder(context, reference.getDecodingFormulaClass()));
        reference.setEncoder(CodecFactory.createEncoder(context, reference.getEncodingFormulaClass()));
        try {
            ValidatorContext ctx = ValidatorContext.builder().field(reference.getField()).typeAnnotation(reference.getDataTypeAnnotation()).protocolType(reference.getProtocolType()).build();
            Validator validator = reference.getDataTypeAnnotation().annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(ctx);
        }
        catch (ResolveException e) {
            throw new ResolveException(MessageFormat.format("Fail resolving the filed of %s", reference.getField().toString()), (Throwable)e);
        }
        this.forward(reference);
    }
}

