/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.util.Optional;
import java.util.function.Supplier;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.crypto.Crypto;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CryptoException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class EncryptFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        byte[] key;
        Graph graph = context.getGraph();
        Reference ref = graph.root();
        if (ref.getEnableCrypto() == null) {
            return;
        }
        byte[] datagram = context.getDatagram();
        Crypto crypto = Crypto.getInstance(ref.getEnableCrypto());
        EnableCrypto enableCrypto = ref.getEnableCrypto();
        if (!enableCrypto.key().isEmpty()) {
            key = enableCrypto.key().getBytes();
        } else if (enableCrypto.keySupplier().length != 0) {
            key = Optional.of(enableCrypto).map(EnableCrypto::keySupplier).map(a -> {
                try {
                    Class c = a[0];
                    return (byte[])((Supplier)c.newInstance()).get();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CryptoException(CodecError.INVALID_CRYPTO_KEY_SUPPLIER, (Throwable)e);
                }
            }).get();
        } else {
            throw new CryptoException(CodecError.NO_CRYPTO_KEY);
        }
        context.setDatagram(crypto.encrypt(key, datagram));
    }

    @Override
    public long getCode() {
        return 1024L;
    }
}

