/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Resolver;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class FastProto {
    public static <T> T parse(@NonNull byte[] datagram, @NonNull Class<T> protocolClass) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        return FastProto.parse(datagram, protocolClass, 0L);
    }

    public static <T> T parse(@NonNull byte[] datagram, @NonNull Class<T> protocolClass, long ... codecFeatures) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        Graph graph = Resolver.resolve(protocolClass);
        long codecFeature = CodecFeature.of(codecFeatures);
        PipelineContext context = PipelineContext.builder().datagram(datagram).protocolClass(protocolClass).codecFeature(codecFeature).graph(graph).build();
        long feature = CodecFeature.of(graph.root());
        Pipeline.getDecodeFlow(feature | codecFeature).process(context);
        return context.getObject(protocolClass);
    }

    public static byte[] toBytes(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toBytes(object, 0L);
    }

    public static byte[] toBytes(@NonNull Object object, int length) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toBytes(object, new byte[length], 0L);
    }

    public static void toBytes(@NonNull Object object, byte[] buffer) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        FastProto.toBytes(object, buffer, 0L);
    }

    public static byte[] toBytes(@NonNull Object object, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Graph graph = Resolver.resolve(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        PipelineContext context = PipelineContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).graph(graph).build();
        long feature = CodecFeature.of(graph.root());
        Pipeline.getEncodeFlow(feature | codecFeature).process(context);
        return context.getDatagram();
    }

    public static byte[] toBytes(@NonNull Object object, int length, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toBytes(object, new byte[length], codecFeatures);
    }

    public static byte[] toBytes(@NonNull Object object, byte[] buffer, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Graph graph = Resolver.resolve(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        PipelineContext context = PipelineContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).datagram(buffer).graph(graph).build();
        long feature = CodecFeature.of(graph.root());
        Pipeline.getEncodeFlow(feature | 0x1000L | codecFeature).process(context);
        return context.getDatagram();
    }
}

