/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BoolType;
import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Int16Type;
import org.indunet.fastproto.annotation.type.Int32Type;
import org.indunet.fastproto.annotation.type.Int64Type;
import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.annotation.type.UInt16Type;
import org.indunet.fastproto.annotation.type.UInt32Type;
import org.indunet.fastproto.annotation.type.UInt64Type;
import org.indunet.fastproto.annotation.type.UInt8Type;
import org.indunet.fastproto.codec.BinaryCodec;
import org.indunet.fastproto.codec.BoolCodec;
import org.indunet.fastproto.codec.ByteCodec;
import org.indunet.fastproto.codec.CalendarCodec;
import org.indunet.fastproto.codec.CharCodec;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.codec.DateCodec;
import org.indunet.fastproto.codec.DoubleCodec;
import org.indunet.fastproto.codec.EnumCodec;
import org.indunet.fastproto.codec.FloatCodec;
import org.indunet.fastproto.codec.InstantCodec;
import org.indunet.fastproto.codec.Int16Codec;
import org.indunet.fastproto.codec.Int32Codec;
import org.indunet.fastproto.codec.Int64Codec;
import org.indunet.fastproto.codec.Int8Codec;
import org.indunet.fastproto.codec.ShortCodec;
import org.indunet.fastproto.codec.StringBufferCodec;
import org.indunet.fastproto.codec.StringBuilderCodec;
import org.indunet.fastproto.codec.StringCodec;
import org.indunet.fastproto.codec.TimestampCodec;
import org.indunet.fastproto.codec.UInt16Codec;
import org.indunet.fastproto.codec.UInt32Codec;
import org.indunet.fastproto.codec.UInt64Codec;
import org.indunet.fastproto.codec.UInt8Codec;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodingException;

public class CodecFactory {
    protected static ConcurrentHashMap<Class, ConcurrentHashMap<Class, Codec>> codecMap = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static boolean isSupported(Type type) {
        return codecMap.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(type::equals);
    }

    public static Codec createCodec(Class type, Class fieldClass) {
        if (!codecMap.containsKey(type)) {
            throw new CodecException(String.format("%s is not supported.", type.toString()));
        }
        ConcurrentHashMap<Class, Codec> map = codecMap.get(type);
        if (Enum.class.isAssignableFrom(fieldClass)) {
            return map.get(Enum.class);
        }
        if (!map.containsKey(fieldClass)) {
            throw new CodecException(String.format("%s cannot be used on %s", type.getSimpleName(), fieldClass));
        }
        return map.get(fieldClass);
    }

    public static <T, R> Function<T, R> createFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, c -> {
            try {
                return (Function)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_FORMULA.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public static Function<byte[], ?> createDecoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).findAny().get();
            Function<byte[], Object> func = bytes -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).decode(context, (byte[])bytes);
            return func.andThen(CodecFactory.createFormula(clazz));
        }
        return bytes -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), context.getFieldType()).decode(context, (byte[])bytes);
    }

    public static BiConsumer<byte[], ? super Object> createEncoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).findAny().get();
            return (bytes, value) -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).encode(context, (byte[])bytes, CodecFactory.createFormula(clazz).apply(value));
        }
        return (bytes, value) -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), context.getFieldType()).encode(context, (byte[])bytes, value);
    }

    static {
        codecMap.put(Int8Type.class, new ConcurrentHashMap());
        codecMap.put(Int16Type.class, new ConcurrentHashMap());
        codecMap.put(Int32Type.class, new ConcurrentHashMap());
        codecMap.put(Int64Type.class, new ConcurrentHashMap());
        codecMap.put(UInt8Type.class, new ConcurrentHashMap());
        codecMap.put(UInt16Type.class, new ConcurrentHashMap());
        codecMap.put(UInt32Type.class, new ConcurrentHashMap());
        codecMap.put(UInt64Type.class, new ConcurrentHashMap());
        codecMap.put(FloatType.class, new ConcurrentHashMap());
        codecMap.put(DoubleType.class, new ConcurrentHashMap());
        codecMap.put(BoolType.class, new ConcurrentHashMap());
        codecMap.put(CharType.class, new ConcurrentHashMap());
        codecMap.put(TimeType.class, new ConcurrentHashMap());
        codecMap.put(BinaryType.class, new ConcurrentHashMap());
        codecMap.put(EnumType.class, new ConcurrentHashMap());
        codecMap.put(StringType.class, new ConcurrentHashMap());
        ByteCodec byteCodec = new ByteCodec();
        Int8Codec int8Codec = new Int8Codec();
        codecMap.get(Int8Type.class).put(Byte.TYPE, byteCodec);
        codecMap.get(Int8Type.class).put(Byte.class, byteCodec);
        codecMap.get(Int8Type.class).put(Integer.TYPE, int8Codec);
        codecMap.get(Int8Type.class).put(Integer.class, int8Codec);
        ShortCodec shortCodec = new ShortCodec();
        Int16Codec int16Codec = new Int16Codec();
        codecMap.get(Int16Type.class).put(Short.TYPE, shortCodec);
        codecMap.get(Int16Type.class).put(Short.class, shortCodec);
        codecMap.get(Int16Type.class).put(Integer.TYPE, int16Codec);
        codecMap.get(Int16Type.class).put(Integer.class, int16Codec);
        Int32Codec int32Codec = new Int32Codec();
        codecMap.get(Int32Type.class).put(Integer.TYPE, int32Codec);
        codecMap.get(Int32Type.class).put(Integer.class, int32Codec);
        Int64Codec int64Codec = new Int64Codec();
        codecMap.get(Int64Type.class).put(Long.TYPE, int64Codec);
        codecMap.get(Int64Type.class).put(Long.class, int64Codec);
        UInt8Codec uint8Codec = new UInt8Codec();
        codecMap.get(UInt8Type.class).put(Integer.TYPE, uint8Codec);
        codecMap.get(UInt8Type.class).put(Integer.class, uint8Codec);
        UInt16Codec uint16Codec = new UInt16Codec();
        codecMap.get(UInt16Type.class).put(Integer.TYPE, uint16Codec);
        codecMap.get(UInt16Type.class).put(Integer.class, uint16Codec);
        UInt32Codec uint32Codec = new UInt32Codec();
        codecMap.get(UInt32Type.class).put(Long.TYPE, uint32Codec);
        codecMap.get(UInt32Type.class).put(Long.class, uint32Codec);
        UInt64Codec uint64Codec = new UInt64Codec();
        codecMap.get(UInt64Type.class).put(BigInteger.class, uint64Codec);
        FloatCodec floatCodec = new FloatCodec();
        codecMap.get(FloatType.class).put(Float.TYPE, floatCodec);
        codecMap.get(FloatType.class).put(Float.class, floatCodec);
        DoubleCodec doubleCodec = new DoubleCodec();
        codecMap.get(DoubleType.class).put(Double.TYPE, doubleCodec);
        codecMap.get(DoubleType.class).put(Double.class, doubleCodec);
        BoolCodec boolCodec = new BoolCodec();
        codecMap.get(BoolType.class).put(Boolean.TYPE, boolCodec);
        codecMap.get(BoolType.class).put(Boolean.class, boolCodec);
        CharCodec charCodec = new CharCodec();
        codecMap.get(CharType.class).put(Character.TYPE, charCodec);
        codecMap.get(CharType.class).put(Character.class, charCodec);
        DateCodec dateCodec = new DateCodec();
        TimestampCodec timestampCodec = new TimestampCodec();
        CalendarCodec calendarCodec = new CalendarCodec();
        InstantCodec instantCodec = new InstantCodec();
        codecMap.get(TimeType.class).put(Date.class, dateCodec);
        codecMap.get(TimeType.class).put(Timestamp.class, timestampCodec);
        codecMap.get(TimeType.class).put(Calendar.class, calendarCodec);
        codecMap.get(TimeType.class).put(Instant.class, instantCodec);
        StringCodec stringCodec = new StringCodec();
        StringBufferCodec stringBufferCodec = new StringBufferCodec();
        StringBuilderCodec stringBuilderCodec = new StringBuilderCodec();
        codecMap.get(StringType.class).put(String.class, stringCodec);
        codecMap.get(StringType.class).put(StringBuffer.class, stringBufferCodec);
        codecMap.get(StringType.class).put(StringBuilder.class, stringBuilderCodec);
        EnumCodec enumCodec = new EnumCodec();
        codecMap.get(EnumType.class).put(Enum.class, enumCodec);
        BinaryCodec binaryCodec = new BinaryCodec();
        codecMap.get(BinaryType.class).put(byte[].class, binaryCodec);
    }
}

