/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ShortCodec
implements Codec<Short> {
    public short decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            return CodecUtils.shortType(bytes, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int16(short) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, short value) {
        try {
            CodecUtils.shortType(bytes, offset, policy, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int16(short) type.", (Throwable)e);
        }
    }

    @Override
    public Short decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Short value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), policy, value);
    }
}

