/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.pipeline.PipelineContext;
import org.indunet.fastproto.pipeline.decode.DecodeFlow;
import org.indunet.fastproto.pipeline.decode.UncompressFlow;
import org.indunet.fastproto.pipeline.decode.VerifyChecksumFlow;
import org.indunet.fastproto.pipeline.decode.VerifyFixedLengthFlow;
import org.indunet.fastproto.pipeline.encode.CompressFlow;
import org.indunet.fastproto.pipeline.encode.EncodeFlow;
import org.indunet.fastproto.pipeline.encode.FixedLengthFlow;
import org.indunet.fastproto.pipeline.encode.InferLengthFlow;
import org.indunet.fastproto.pipeline.encode.WriteChecksumFlow;

public abstract class Pipeline<T> {
    protected static Class<? extends Pipeline>[] decodeFlowClasses = new Class[]{UncompressFlow.class, VerifyFixedLengthFlow.class, VerifyChecksumFlow.class, DecodeFlow.class};
    protected static Class<? extends Pipeline>[] encodeFlowClasses = new Class[]{InferLengthFlow.class, FixedLengthFlow.class, EncodeFlow.class, WriteChecksumFlow.class, CompressFlow.class};
    Pipeline<T> next = null;
    protected static ConcurrentMap<Long, Pipeline> decodeFlows = new ConcurrentHashMap<Long, Pipeline>();
    protected static ConcurrentMap<Long, Pipeline> encodeFlows = new ConcurrentHashMap<Long, Pipeline>();
    protected static Pipeline<ValidatorContext> validateFlow;

    public abstract void process(T var1);

    public Pipeline<T> setNext(Pipeline<T> next) {
        this.next = next;
        return this.next;
    }

    public void forward(T context) {
        if (this.next != null) {
            this.next.process(context);
        }
    }

    public Pipeline<T> append(Class<? extends Pipeline<T>> clazz) {
        Pipeline<T> temp = this;
        while (temp.next != null) {
            temp = temp.next;
        }
        try {
            temp.setNext(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodingException(CodecError.FAIL_CREATING_DECODE_FLOW, (Throwable)e);
        }
        return this;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (this.next != null) {
            return String.format("%s -> %s", name, this.next);
        }
        return name;
    }

    public abstract long getCode();

    public static Pipeline<PipelineContext> getDecodeFlow(long codecFeature) {
        return decodeFlows.computeIfAbsent(codecFeature, __ -> Pipeline.create(decodeFlowClasses, codecFeature));
    }

    public static Pipeline<PipelineContext> getEncodeFlow(long codecFeature) {
        return encodeFlows.computeIfAbsent(codecFeature, __ -> Pipeline.create(encodeFlowClasses, codecFeature));
    }

    public static Pipeline create(Class<? extends Pipeline>[] flowClasses, long codecFeature) {
        Pipeline[] array = (Pipeline[])Arrays.stream(flowClasses).map(c -> {
            try {
                return (Pipeline)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(CodecError.FAIL_CREATING_DECODE_FLOW, (Throwable)e);
            }
        }).filter(f -> (f.getCode() & codecFeature) == 0L).toArray(Pipeline[]::new);
        Pipeline flow = array[0];
        for (int i = 1; i < array.length; ++i) {
            flow.setNext(array[i]);
            flow = flow.next;
        }
        return array[0];
    }

    public static <T> Pipeline<T> create(Class<? extends Pipeline<T>>[] pipelines) {
        return Pipeline.create(pipelines, 0L);
    }
}

