/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.DoubleArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DoubleArrayCodec
implements Codec<double[]> {
    public double[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToDouble(i -> CodecUtils.doubleType(bytes, o + i * 8)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding double array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, double[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            if (l >= values.length) {
                IntStream.range(0, values.length).forEach(i -> CodecUtils.doubleType(bytes, offset + i * 8, values[i]));
            } else {
                IntStream.range(0, l).forEach(i -> CodecUtils.doubleType(bytes, offset + i * 8, values[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding double array type.", (Throwable)e);
        }
    }

    @Override
    public double[] decode(CodecContext context, byte[] bytes) {
        DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, double[] value) {
        DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

