/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.Int64ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int64ArrayCodec
implements Codec<long[]> {
    public long[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToLong(i -> CodecUtils.int64Type(bytes, o + i * 8)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, long[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int64Type(bytes, o + i * 8, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int32 array type.", (Throwable)e);
        }
    }

    @Override
    public long[] decode(CodecContext context, byte[] bytes) {
        Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, long[] value) {
        Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

