/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.Int16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ShortArrayCodec
implements Codec<short[]> {
    public short[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            short[] values = new short[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = CodecUtils.shortType(bytes, o + i * 2);
            });
            return values;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding short array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, short[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.shortType(bytes, o + i * 2, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding short array type.", (Throwable)e);
        }
    }

    @Override
    public short[] decode(CodecContext context, byte[] bytes) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, short[] value) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

