/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.UInt16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt16ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            return IntStream.range(0, l).map(i -> CodecUtils.uint16Type(bytes, o + i * 2)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint16 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint16Type(bytes, o + i * 2, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint16 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, int[] value) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

