/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.UInt32ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt32ArrayCodec
implements Codec<long[]> {
    public long[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            return IntStream.range(0, l).mapToLong(i -> CodecUtils.uint32Type(bytes, o + i * 4)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, long[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint32Type(bytes, o + i * 4, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint32 array type.", (Throwable)e);
        }
    }

    @Override
    public long[] decode(CodecContext context, byte[] bytes) {
        UInt32ArrayType type = context.getDataTypeAnnotation(UInt32ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, long[] value) {
        UInt32ArrayType type = context.getDataTypeAnnotation(UInt32ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

