/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BinaryCodec
implements Codec<byte[]> {
    public byte[] decode(byte[] bytes, int offset, int length) {
        try {
            return CodecUtils.binaryType(bytes, offset, length);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding binary type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, byte[] values) {
        try {
            CodecUtils.binaryType(bytes, offset, length, values);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding binary type.", (Throwable)e);
        }
    }

    @Override
    public byte[] decode(CodecContext context, byte[] bytes) {
        BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, byte[] value) {
        BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class WrapperCodec
    implements Codec<Byte[]> {
        @Override
        public Byte[] decode(CodecContext context, byte[] bytes) {
            byte[] bs = BinaryCodec.this.decode(context, bytes);
            Byte[] values = new Byte[bs.length];
            IntStream.range(0, bs.length).forEach(i -> {
                values[i] = bs[i];
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Byte[] values) {
            byte[] bs = new byte[values.length];
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i];
            });
            BinaryCodec.this.encode(context, bytes, bs);
        }
    }
}

