/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BoolType;
import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.annotation.type.DoubleArrayType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.annotation.type.FloatArrayType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Int16ArrayType;
import org.indunet.fastproto.annotation.type.Int16Type;
import org.indunet.fastproto.annotation.type.Int32ArrayType;
import org.indunet.fastproto.annotation.type.Int32Type;
import org.indunet.fastproto.annotation.type.Int64ArrayType;
import org.indunet.fastproto.annotation.type.Int64Type;
import org.indunet.fastproto.annotation.type.Int8ArrayType;
import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.annotation.type.UInt16ArrayType;
import org.indunet.fastproto.annotation.type.UInt16Type;
import org.indunet.fastproto.annotation.type.UInt32ArrayType;
import org.indunet.fastproto.annotation.type.UInt32Type;
import org.indunet.fastproto.annotation.type.UInt64ArrayType;
import org.indunet.fastproto.annotation.type.UInt64Type;
import org.indunet.fastproto.annotation.type.UInt8ArrayType;
import org.indunet.fastproto.annotation.type.UInt8Type;
import org.indunet.fastproto.codec.AsciiCodec;
import org.indunet.fastproto.codec.BinaryCodec;
import org.indunet.fastproto.codec.BoolCodec;
import org.indunet.fastproto.codec.ByteCodec;
import org.indunet.fastproto.codec.CalendarCodec;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.codec.DateCodec;
import org.indunet.fastproto.codec.DoubleArrayCodec;
import org.indunet.fastproto.codec.DoubleCodec;
import org.indunet.fastproto.codec.EnumCodec;
import org.indunet.fastproto.codec.FloatArrayCodec;
import org.indunet.fastproto.codec.FloatCodec;
import org.indunet.fastproto.codec.InstantCodec;
import org.indunet.fastproto.codec.Int16ArrayCodec;
import org.indunet.fastproto.codec.Int16Codec;
import org.indunet.fastproto.codec.Int32ArrayCodec;
import org.indunet.fastproto.codec.Int32Codec;
import org.indunet.fastproto.codec.Int64ArrayCodec;
import org.indunet.fastproto.codec.Int64Codec;
import org.indunet.fastproto.codec.Int8ArrayCodec;
import org.indunet.fastproto.codec.Int8Codec;
import org.indunet.fastproto.codec.ShortArrayCodec;
import org.indunet.fastproto.codec.ShortCodec;
import org.indunet.fastproto.codec.StringBufferCodec;
import org.indunet.fastproto.codec.StringBuilderCodec;
import org.indunet.fastproto.codec.StringCodec;
import org.indunet.fastproto.codec.TimestampCodec;
import org.indunet.fastproto.codec.UInt16ArrayCodec;
import org.indunet.fastproto.codec.UInt16Codec;
import org.indunet.fastproto.codec.UInt32ArrayCodec;
import org.indunet.fastproto.codec.UInt32Codec;
import org.indunet.fastproto.codec.UInt64ArrayCodec;
import org.indunet.fastproto.codec.UInt64Codec;
import org.indunet.fastproto.codec.UInt8ArrayCodec;
import org.indunet.fastproto.codec.UInt8Codec;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodingException;

public class CodecFactory {
    protected static ConcurrentHashMap<Class, ConcurrentHashMap<Class, Codec>> codecMap = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static boolean isSupported(Type type) {
        return codecMap.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(type::equals);
    }

    public static Codec createCodec(Class type, Class fieldClass) {
        if (!codecMap.containsKey(type)) {
            throw new CodecException(String.format("%s is not supported.", type.toString()));
        }
        ConcurrentHashMap<Class, Codec> map = codecMap.get(type);
        if (Enum.class.isAssignableFrom(fieldClass)) {
            return map.get(Enum.class);
        }
        if (!map.containsKey(fieldClass)) {
            throw new CodecException(String.format("%s cannot be used on %s", type.getSimpleName(), fieldClass));
        }
        return map.get(fieldClass);
    }

    public static <T, R> Function<T, R> createFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, c -> {
            try {
                return (Function)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_FORMULA.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public static Function<byte[], ?> createDecoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).findAny().get();
            Function<byte[], Object> func = bytes -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).decode(context, (byte[])bytes);
            return func.andThen(CodecFactory.createFormula(clazz));
        }
        return bytes -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), context.getFieldType()).decode(context, (byte[])bytes);
    }

    public static BiConsumer<byte[], ? super Object> createEncoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).findAny().get();
            return (bytes, value) -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).encode(context, (byte[])bytes, CodecFactory.createFormula(clazz).apply(value));
        }
        return (bytes, value) -> CodecFactory.createCodec(context.getDataTypeAnnotation().annotationType(), context.getFieldType()).encode(context, (byte[])bytes, value);
    }

    static {
        codecMap.put(Int8Type.class, new ConcurrentHashMap());
        codecMap.put(Int8ArrayType.class, new ConcurrentHashMap());
        codecMap.put(BinaryType.class, new ConcurrentHashMap());
        codecMap.put(Int16Type.class, new ConcurrentHashMap());
        codecMap.put(Int16ArrayType.class, new ConcurrentHashMap());
        codecMap.put(Int32Type.class, new ConcurrentHashMap());
        codecMap.put(Int32ArrayType.class, new ConcurrentHashMap());
        codecMap.put(Int64Type.class, new ConcurrentHashMap());
        codecMap.put(Int64ArrayType.class, new ConcurrentHashMap());
        codecMap.put(UInt8Type.class, new ConcurrentHashMap());
        codecMap.put(UInt8ArrayType.class, new ConcurrentHashMap());
        codecMap.put(UInt16Type.class, new ConcurrentHashMap());
        codecMap.put(UInt16ArrayType.class, new ConcurrentHashMap());
        codecMap.put(UInt32Type.class, new ConcurrentHashMap());
        codecMap.put(UInt32ArrayType.class, new ConcurrentHashMap());
        codecMap.put(UInt64Type.class, new ConcurrentHashMap());
        codecMap.put(UInt64ArrayType.class, new ConcurrentHashMap());
        codecMap.put(FloatType.class, new ConcurrentHashMap());
        codecMap.put(FloatArrayType.class, new ConcurrentHashMap());
        codecMap.put(DoubleType.class, new ConcurrentHashMap());
        codecMap.put(DoubleArrayType.class, new ConcurrentHashMap());
        codecMap.put(BoolType.class, new ConcurrentHashMap());
        codecMap.put(CharType.class, new ConcurrentHashMap());
        codecMap.put(TimeType.class, new ConcurrentHashMap());
        codecMap.put(EnumType.class, new ConcurrentHashMap());
        codecMap.put(StringType.class, new ConcurrentHashMap());
        ByteCodec byteCodec = new ByteCodec();
        BinaryCodec binaryCodec = new BinaryCodec();
        codecMap.get(Int8Type.class).put(Byte.TYPE, byteCodec);
        codecMap.get(Int8Type.class).put(Byte.class, byteCodec);
        codecMap.get(BinaryType.class).put(byte[].class, binaryCodec);
        codecMap.get(BinaryType.class).put(Byte[].class, binaryCodec.new BinaryCodec.WrapperCodec());
        Int8Codec int8Codec = new Int8Codec();
        Int8ArrayCodec int8ArrayCodec = new Int8ArrayCodec();
        codecMap.get(Int8Type.class).put(Integer.TYPE, int8Codec);
        codecMap.get(Int8Type.class).put(Integer.class, int8Codec);
        codecMap.get(Int8ArrayType.class).put(byte[].class, binaryCodec);
        codecMap.get(Int8ArrayType.class).put(int[].class, int8ArrayCodec);
        codecMap.get(Int8ArrayType.class).put(Integer[].class, new Int8ArrayCodec.WrapperCodec(int8ArrayCodec));
        ShortCodec shortCodec = new ShortCodec();
        Int16Codec int16Codec = new Int16Codec();
        ShortArrayCodec shortArrayCodec = new ShortArrayCodec();
        Int16ArrayCodec int16ArrayCodec = new Int16ArrayCodec();
        codecMap.get(Int16Type.class).put(Short.TYPE, shortCodec);
        codecMap.get(Int16Type.class).put(Short.class, shortCodec);
        codecMap.get(Int16Type.class).put(Integer.TYPE, int16Codec);
        codecMap.get(Int16Type.class).put(Integer.class, int16Codec);
        codecMap.get(Int16ArrayType.class).put(short[].class, shortArrayCodec);
        codecMap.get(Int16ArrayType.class).put(int[].class, int16ArrayCodec);
        codecMap.get(Int16ArrayType.class).put(Integer[].class, new Int16ArrayCodec.WrapperCodec(int16ArrayCodec));
        codecMap.get(Int16ArrayType.class).put(Short[].class, new ShortArrayCodec.WrapperCodec(shortArrayCodec));
        Int32Codec int32Codec = new Int32Codec();
        Int32ArrayCodec int32ArrayCodec = new Int32ArrayCodec();
        codecMap.get(Int32Type.class).put(Integer.TYPE, int32Codec);
        codecMap.get(Int32Type.class).put(Integer.class, int32Codec);
        codecMap.get(Int32ArrayType.class).put(int[].class, int32ArrayCodec);
        codecMap.get(Int32ArrayType.class).put(Integer[].class, new Int32ArrayCodec.WrapperCodec(int32ArrayCodec));
        Int64Codec int64Codec = new Int64Codec();
        Int64ArrayCodec int64ArrayCodec = new Int64ArrayCodec();
        codecMap.get(Int64Type.class).put(Long.TYPE, int64Codec);
        codecMap.get(Int64Type.class).put(Long.class, int64Codec);
        codecMap.get(Int64ArrayType.class).put(long[].class, int64ArrayCodec);
        codecMap.get(Int64ArrayType.class).put(Long[].class, new Int64ArrayCodec.WrapperCodec(int64ArrayCodec));
        UInt8Codec uint8Codec = new UInt8Codec();
        UInt8ArrayCodec uint8ArrayCodec = new UInt8ArrayCodec();
        codecMap.get(UInt8Type.class).put(Integer.TYPE, uint8Codec);
        codecMap.get(UInt8Type.class).put(Integer.class, uint8Codec);
        codecMap.get(UInt8ArrayType.class).put(int[].class, uint8ArrayCodec);
        codecMap.get(UInt8ArrayType.class).put(Integer[].class, new UInt8ArrayCodec.WrapperCodec(uint8ArrayCodec));
        UInt16Codec uint16Codec = new UInt16Codec();
        UInt16ArrayCodec uint16ArrayCodec = new UInt16ArrayCodec();
        codecMap.get(UInt16Type.class).put(Integer.TYPE, uint16Codec);
        codecMap.get(UInt16Type.class).put(Integer.class, uint16Codec);
        codecMap.get(UInt16ArrayType.class).put(int[].class, uint16ArrayCodec);
        codecMap.get(UInt16ArrayType.class).put(Integer[].class, new UInt16ArrayCodec.WrapperCodec(uint16ArrayCodec));
        UInt32Codec uint32Codec = new UInt32Codec();
        UInt32ArrayCodec uint32ArrayCodec = new UInt32ArrayCodec();
        codecMap.get(UInt32Type.class).put(Long.TYPE, uint32Codec);
        codecMap.get(UInt32Type.class).put(Long.class, uint32Codec);
        codecMap.get(UInt32ArrayType.class).put(long[].class, uint32ArrayCodec);
        codecMap.get(UInt32ArrayType.class).put(Long[].class, new UInt32ArrayCodec.WrapperCodec(uint32ArrayCodec));
        UInt64Codec uint64Codec = new UInt64Codec();
        UInt64ArrayCodec uint64ArrayCodec = new UInt64ArrayCodec();
        codecMap.get(UInt64Type.class).put(BigInteger.class, uint64Codec);
        codecMap.get(UInt64ArrayType.class).put(BigInteger[].class, uint64ArrayCodec);
        FloatCodec floatCodec = new FloatCodec();
        FloatArrayCodec floatArrayCodec = new FloatArrayCodec();
        codecMap.get(FloatType.class).put(Float.TYPE, floatCodec);
        codecMap.get(FloatType.class).put(Float.class, floatCodec);
        codecMap.get(FloatArrayType.class).put(float[].class, floatArrayCodec);
        codecMap.get(FloatArrayType.class).put(Float[].class, new FloatArrayCodec.WrapperCodec(floatArrayCodec));
        DoubleCodec doubleCodec = new DoubleCodec();
        DoubleArrayCodec doubleArrayCodec = new DoubleArrayCodec();
        codecMap.get(DoubleType.class).put(Double.TYPE, doubleCodec);
        codecMap.get(DoubleType.class).put(Double.class, doubleCodec);
        codecMap.get(DoubleArrayType.class).put(double[].class, doubleArrayCodec);
        codecMap.get(DoubleArrayType.class).put(Double[].class, new DoubleArrayCodec.WrapperCodec(doubleArrayCodec));
        BoolCodec boolCodec = new BoolCodec();
        codecMap.get(BoolType.class).put(Boolean.TYPE, boolCodec);
        codecMap.get(BoolType.class).put(Boolean.class, boolCodec);
        AsciiCodec charCodec = new AsciiCodec();
        codecMap.get(CharType.class).put(Character.TYPE, charCodec);
        codecMap.get(CharType.class).put(Character.class, charCodec);
        DateCodec dateCodec = new DateCodec();
        TimestampCodec timestampCodec = new TimestampCodec();
        CalendarCodec calendarCodec = new CalendarCodec();
        InstantCodec instantCodec = new InstantCodec();
        codecMap.get(TimeType.class).put(Date.class, dateCodec);
        codecMap.get(TimeType.class).put(Timestamp.class, timestampCodec);
        codecMap.get(TimeType.class).put(Calendar.class, calendarCodec);
        codecMap.get(TimeType.class).put(Instant.class, instantCodec);
        StringCodec stringCodec = new StringCodec();
        StringBufferCodec stringBufferCodec = new StringBufferCodec();
        StringBuilderCodec stringBuilderCodec = new StringBuilderCodec();
        codecMap.get(StringType.class).put(String.class, stringCodec);
        codecMap.get(StringType.class).put(StringBuffer.class, stringBufferCodec);
        codecMap.get(StringType.class).put(StringBuilder.class, stringBuilderCodec);
        EnumCodec enumCodec = new EnumCodec();
        codecMap.get(EnumType.class).put(Enum.class, enumCodec);
    }
}

