/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.FloatArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class FloatArrayCodec
implements Codec<float[]> {
    public float[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            float[] values = new float[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = CodecUtils.floatType(bytes, o + i * 4);
            });
            return values;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding float array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, float[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            if (l >= values.length) {
                IntStream.range(0, values.length).forEach(i -> CodecUtils.floatType(bytes, offset + i * 4, values[i]));
            } else {
                IntStream.range(0, l).forEach(i -> CodecUtils.floatType(bytes, offset + i * 4, values[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding float array type.", (Throwable)e);
        }
    }

    @Override
    public float[] decode(CodecContext context, byte[] bytes) {
        FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, float[] value) {
        FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class WrapperCodec
    implements Codec<Float[]> {
        @Override
        public Float[] decode(CodecContext context, byte[] bytes) {
            float[] floats = FloatArrayCodec.this.decode(context, bytes);
            Float[] values = new Float[floats.length];
            IntStream.range(0, floats.length).forEach(i -> {
                values[i] = Float.valueOf(floats[i]);
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Float[] values) {
            float[] floats = new float[values.length];
            IntStream.range(0, floats.length).forEach(i -> {
                floats[i] = values[i].floatValue();
            });
            FloatArrayCodec.this.encode(context, bytes, floats);
        }
    }
}

