/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.annotation.type.Int32ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int32ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            return IntStream.range(0, l).map(i -> CodecUtils.int32Type(bytes, o + i * 4)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int32Type(bytes, o + i * 4, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int32 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        Int32ArrayType type = context.getDataTypeAnnotation(Int32ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, int[] value) {
        Int32ArrayType type = context.getDataTypeAnnotation(Int32ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(Int32ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            Int32ArrayCodec.this.encode(context, bytes, ints);
        }
    }
}

