/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;

public class ConstructorFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        int cnt = Arrays.stream(protocolClass.getConstructors()).mapToInt(Constructor::getParameterCount).min().getAsInt();
        if (cnt == 0) {
            reference.setConstructorType(Reference.ConstructorType.NO_ARGS);
        } else {
            Class[] paramTypes = (Class[])Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !Modifier.isTransient(f.getModifiers())).map(Field::getType).toArray(Class[]::new);
            try {
                protocolClass.getConstructor(paramTypes);
                reference.setConstructorType(Reference.ConstructorType.ALL_ARGS);
            }
            catch (NoSuchMethodException e) {
                throw new ResolveException(String.format("The constructor parameters of %s and class fields does not match.", protocolClass.getName()), (Throwable)e);
            }
        }
        this.forward(reference);
    }
}

