/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Optional;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.DecodingFormula;
import org.indunet.fastproto.annotation.EncodingFormula;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;

public class FieldValidator
extends TypeValidator {
    @Override
    public void process(ValidatorContext context) {
        ProtocolType protocolType = context.getProtocolType();
        Class<? extends Annotation> typeAnnotationClass = context.getTypeAnnotationClass();
        Field field = context.getField();
        Class decodingFormula = Optional.ofNullable(field.getAnnotation(DecodingFormula.class)).map(DecodingFormula::value).orElse(null);
        Class encodingFormula = Optional.ofNullable(field.getAnnotation(EncodingFormula.class)).map(EncodingFormula::value).orElse(null);
        try {
            context.setDecodingFormula(decodingFormula);
            context.setEncodingFormula(encodingFormula);
        }
        catch (Exception e) {
            throw new DecodeFormulaException(MessageFormat.format(CodecError.FAIL_GETTING_DECODE_FORMULA.getMessage(), protocolType.getType().getName(), field.getName()), (Throwable)e);
        }
        this.forward(context);
    }
}

