/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.indunet.fastproto.annotation.type.UInt32ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt32ArrayCodec
implements Codec<long[]> {
    public long[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            return IntStream.range(0, l).mapToLong(i -> CodecUtils.uint32Type(bytes, o + i * 4)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, long[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint32Type(bytes, o + i * 4, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint32 array type.", (Throwable)e);
        }
    }

    @Override
    public long[] decode(CodecContext context, byte[] bytes) {
        UInt32ArrayType type = context.getDataTypeAnnotation(UInt32ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, long[] value) {
        UInt32ArrayType type = context.getDataTypeAnnotation(UInt32ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class CollectionCodec
    implements Codec<Collection<Long>> {
        @Override
        public Collection<Long> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt32ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Long> collection) {
            UInt32ArrayCodec.this.encode(context, bytes, collection.stream().mapToLong(Long::longValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Long[]> {
        @Override
        public Long[] decode(CodecContext context, byte[] bytes) {
            return (Long[])LongStream.of(UInt32ArrayCodec.this.decode(context, bytes)).mapToObj(Long::valueOf).toArray(Long[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Long[] values) {
            long[] longs = Stream.of(values).mapToLong(i -> i).toArray();
            UInt32ArrayCodec.this.encode(context, bytes, longs);
        }
    }
}

