/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.type.UInt64ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt64ArrayCodec
implements Codec<BigInteger[]> {
    public BigInteger[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            return (BigInteger[])IntStream.range(0, l).mapToObj(i -> CodecUtils.uint64Type(bytes, o + i * 8)).toArray(BigInteger[]::new);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint64 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, BigInteger[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint64Type(bytes, o + i * 8, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            throw new EncodingException("Fail encoding uint64 array type.", (Throwable)e);
        }
    }

    @Override
    public BigInteger[] decode(CodecContext context, byte[] bytes) {
        UInt64ArrayType type = context.getDataTypeAnnotation(UInt64ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, BigInteger[] value) {
        UInt64ArrayType type = context.getDataTypeAnnotation(UInt64ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class CollectionCodec
    implements Codec<Collection<BigInteger>> {
        @Override
        public Collection<BigInteger> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt64ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<BigInteger> collection) {
            UInt64ArrayCodec.this.encode(context, bytes, (BigInteger[])collection.stream().toArray(BigInteger[]::new));
        }
    }
}

