/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.exception.AddressingException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class InferLengthFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Graph graph = context.getGraph();
        int max = graph.stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.FIELD).mapToInt(r -> {
            ProtocolType type = r.getProtocolType();
            if (type.offset() < 0 || type.length() < 0) {
                throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
            }
            return type.offset() + type.size() + type.length();
        }).max().orElse(0);
        if (max == 0) {
            throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
        }
        context.setDatagram(new byte[max]);
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 4096L;
    }
}

