/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.text.MessageFormat;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.codec.CodecMapper;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        BiConsumer<byte[], ? super Object> encoder;
        Function func;
        Function<byte[], ?> decoder;
        CodecContext context = CodecContext.builder().dataTypeAnnotation(reference.getDataTypeAnnotation()).fieldType(reference.getField().getType()).field(reference.getField()).defaultEndianPolicy(reference.getEndianPolicy()).build();
        if (reference.getDecodingFormulaClass() != null) {
            decoder = CodecMapper.getDecoder(context, reference.getDecodingFormulaClass());
            reference.setDecoder(decoder);
        } else if (reference.getDecodingLambda() != null) {
            decoder = CodecMapper.getDefaultDecoder(context, reference.getProtocolType().defaultJavaType());
            func = reference.getDecodingLambda();
            reference.setDecoder(decoder.andThen(func));
        } else {
            decoder = CodecMapper.getDecoder(context, null);
            reference.setDecoder(decoder);
        }
        if (reference.getEncodingFormulaClass() != null) {
            encoder = CodecMapper.getEncoder(context, reference.getEncodingFormulaClass());
            reference.setEncoder(encoder);
        } else if (reference.getEncodingLambda() != null) {
            encoder = CodecMapper.getDefaultEncoder(context, reference.getProtocolType().defaultJavaType());
            func = reference.getEncodingLambda();
            reference.setEncoder((bytes, value) -> encoder.accept((byte[])bytes, func.apply(value)));
        } else {
            encoder = CodecMapper.getEncoder(context, null);
            reference.setEncoder(encoder);
        }
        try {
            ValidatorContext ctx = ValidatorContext.builder().field(reference.getField()).typeAnnotation(reference.getDataTypeAnnotation()).protocolType(reference.getProtocolType()).decodingFormulaClass(reference.getDecodingFormulaClass()).encodingFormulaClass(reference.getEncodingFormulaClass()).build();
            Validator validator = reference.getDataTypeAnnotation().annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(ctx);
        }
        catch (ResolveException e) {
            throw new ResolveException(MessageFormat.format("Fail resolving the filed of %s", reference.getField().toString()), (Throwable)e);
        }
        this.forward(reference);
    }
}

