/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static Collection newInstance(Class<? extends Collection> clazz) throws InstantiationException, IllegalAccessException {
        if (!clazz.isInterface()) {
            return clazz.newInstance();
        }
        if (clazz.equals(Collection.class) || clazz.equals(List.class)) {
            return new ArrayList();
        }
        if (clazz.equals(Set.class)) {
            return new HashSet();
        }
        if (clazz.equals(Deque.class)) {
            return new ArrayDeque();
        }
        throw new IllegalArgumentException(String.format("%s type is not supported", clazz.getName()));
    }

    public static Type elementType(Class<? extends Collection> clazz) {
        return Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).findAny().orElseThrow(() -> new IllegalArgumentException("Fail getting element type"));
    }
}

