/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.formula;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.indunet.fastproto.exception.FormulaException;
import org.indunet.fastproto.formula.FormulaBuilderTemplate;
import org.indunet.fastproto.formula.compiler.JavaStringCompiler;

public interface FormulaBuilder {
    public static FormulaBuilder create(Class inputType, String lambda) {
        try {
            JavaStringCompiler compiler = new JavaStringCompiler();
            FormulaBuilderTemplate template = new FormulaBuilderTemplate(inputType, lambda);
            Map<String, byte[]> results = compiler.compile(template.fileName(), template.toSourceCode());
            Class<?> clazz = compiler.loadClass(template.fullName(), results);
            return (FormulaBuilder)clazz.newInstance();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new FormulaException(String.format("Fail compiling lambda expression: %s", lambda), (Throwable)e);
        }
    }

    public Function build();
}

