/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.formula.compiler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.indunet.fastproto.exception.FormulaException;
import org.indunet.fastproto.formula.compiler.MemoryClassLoader;
import org.indunet.fastproto.formula.compiler.MemoryJavaFileManager;

public class JavaStringCompiler {
    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    StandardJavaFileManager stdManager = this.compiler.getStandardFileManager(null, null, null);

    public Map<String, byte[]> compile(String fileName, String sourceCode) throws IOException {
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager);){
            JavaFileObject javaFileObject = manager.makeStringSource(fileName, sourceCode);
            List<String> options = Arrays.asList("-source", "1.8", "-target", "1.8", "-proc:none");
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, manager, null, options, null, Arrays.asList(javaFileObject));
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                throw new FormulaException("Fail compiling lambda expression.");
            }
            Map<String, byte[]> map = manager.getClassBytes();
            return map;
        }
    }

    public Class<?> loadClass(String name, Map<String, byte[]> classBytes) throws ClassNotFoundException, IOException {
        try (MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);){
            Class<?> clazz = classLoader.loadClass(name);
            return clazz;
        }
    }
}

