/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.FormulaException;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.util.TypeUtils;

public class DecodingFormulaValidator
extends TypeValidator {
    @Override
    public void process(ValidatorContext context) {
        Class<? extends Function> decodeFormula = context.getDecodingFormulaClass();
        Annotation typeAnnotation = context.getTypeAnnotation();
        Field field = context.getField();
        if (decodeFormula != null) {
            Arrays.stream(decodeFormula.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).filter(t -> {
                if (field.getType().isPrimitive()) {
                    return t == TypeUtils.wrapperClass(field.getType().getName());
                }
                if (field.getType().isEnum()) {
                    return ((Class)t).isAssignableFrom(field.getType());
                }
                return t == field.getType();
            }).findAny().orElseThrow(() -> new FormulaException(MessageFormat.format(CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
        }
        this.forward(context);
    }
}

