/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Calendar;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CalendarCodec
implements Codec<Calendar> {
    public Calendar decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, policy);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(calendar) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, Calendar calendar) {
        try {
            long millis = calendar.getTimeInMillis();
            CodecUtils.int64Type(bytes, offset, policy, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(calendar) type.", (Throwable)e);
        }
    }

    @Override
    public Calendar decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Calendar value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), policy, value);
    }
}

