/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Date;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DateCodec
implements Codec<Date> {
    public Date decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, policy);
            return new Date(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(date) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, Date value) {
        try {
            long millis = value.getTime();
            CodecUtils.int64Type(bytes, offset, policy, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(date) type.", (Throwable)e);
        }
    }

    @Override
    public Date decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Date value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), policy, value);
    }
}

