/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.annotation.Int8ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class Int8ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            return IntStream.range(0, l).map(i -> CodecUtils.int8Type(bytes, o + i)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            IntStream.range(0, l).forEach(i -> CodecUtils.int8Type(bytes, o + i, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int8 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        Int8ArrayType type = context.getDataTypeAnnotation(Int8ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, int[] value) {
        Int8ArrayType type = context.getDataTypeAnnotation(Int8ArrayType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(Int8ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Integer> collection) {
            Int8ArrayCodec.this.encode(context, bytes, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(Int8ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            Int8ArrayCodec.this.encode(context, bytes, ints);
        }
    }
}

