/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.UInt8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt8Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int offset) {
        try {
            return CodecUtils.uint8Type(bytes, offset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int value) {
        try {
            CodecUtils.uint8Type(bytes, offset, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int8 type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        UInt8Type type = context.getDataTypeAnnotation(UInt8Type.class);
        return this.decode(bytes, type.offset());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        UInt8Type type = context.getDataTypeAnnotation(UInt8Type.class);
        this.encode(bytes, type.offset(), (int)value);
    }
}

