/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.AutoType;
import org.indunet.fastproto.annotation.BinaryType;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.annotation.CharType;
import org.indunet.fastproto.annotation.DoubleType;
import org.indunet.fastproto.annotation.EnumType;
import org.indunet.fastproto.annotation.FloatType;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.annotation.Int64Type;
import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.annotation.StringType;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.annotation.UInt16Type;
import org.indunet.fastproto.annotation.UInt32Type;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.annotation.UInt8Type;
import org.indunet.fastproto.exception.ResolveException;

public interface ProtocolType {
    public static final Class<? extends Annotation> BINARY = BinaryType.class;
    public static final Class<? extends Annotation> BOOL = BoolType.class;
    public static final Class<? extends Annotation> CHAR = CharType.class;
    public static final Class<? extends Annotation> DOUBLE = DoubleType.class;
    public static final Class<? extends Annotation> FLOAT = FloatType.class;
    public static final Class<? extends Annotation> INT32 = Int32Type.class;
    public static final Class<? extends Annotation> INT64 = Int64Type.class;
    public static final Class<? extends Annotation> STRING = StringType.class;
    public static final Class<? extends Annotation> TIME = TimeType.class;
    public static final Class<? extends Annotation> INT8 = Int8Type.class;
    public static final Class<? extends Annotation> INT16 = Int16Type.class;
    public static final Class<? extends Annotation> UINT8 = UInt8Type.class;
    public static final Class<? extends Annotation> UINT16 = UInt16Type.class;
    public static final Class<? extends Annotation> UINT32 = UInt32Type.class;
    public static final Class<? extends Annotation> UINT64 = UInt64Type.class;
    public static final Class<? extends Annotation> ENUM = EnumType.class;

    public static <T> T proxy(AutoType autoType, Class<T> dataTypeAnnotationClass) {
        return (T)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{dataTypeAnnotationClass}, (proxy, method, args) -> {
            Method mth = Arrays.stream(autoType.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get();
            if (Arrays.asList("offset", "byteOffset", "bitOffset", "length").contains(mth.getName())) {
                int[] ints = (int[])mth.invoke((Object)autoType, args);
                if (ints.length != 0) {
                    return ints[0];
                }
                throw new ResolveException(String.format("Autotype lack of property %s", mth.getName()));
            }
            if (Arrays.asList("endian", "charset", "name").contains(method.getName())) {
                return mth.invoke((Object)autoType, args);
            }
            if (mth.getName().equals("annotationType")) {
                return dataTypeAnnotationClass;
            }
            return null;
        });
    }

    public static ProtocolType proxy(Annotation typeAnnotation) {
        return (ProtocolType)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{ProtocolType.class, typeAnnotation.annotationType()}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "getType": {
                    return typeAnnotation.annotationType();
                }
                case "size": {
                    try {
                        return typeAnnotation.annotationType().getDeclaredField("SIZE").getInt(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return 0;
                    }
                }
                case "length": {
                    if (Arrays.stream(typeAnnotation.getClass().getMethods()).noneMatch(m -> m.getName().equals("length"))) {
                        return 0;
                    }
                }
                case "defaultJavaType": {
                    try {
                        return (Class)typeAnnotation.annotationType().getDeclaredField("DEFAULT_JAVA_TYPE").get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return null;
                    }
                }
            }
            if (typeAnnotation.annotationType() == BoolType.class && method.getName().equals("offset")) {
                return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals("byteOffset")).findAny().get().invoke((Object)typeAnnotation, args);
            }
            return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get().invoke((Object)typeAnnotation, args);
        });
    }

    public int offset();

    public int byteOffset();

    public int bitOffset();

    public int length();

    public String field();

    public EndianPolicy[] endianPolicy();

    public Class<? extends Annotation> getType();

    public int size();
}

