/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.sql.Timestamp;
import java.util.Arrays;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class TimestampCodec
implements Codec<Timestamp> {
    public Timestamp decode(byte[] datagram, int offset, EndianPolicy policy) {
        try {
            long millis = CodecUtils.int64Type(datagram, offset, policy);
            return new Timestamp(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(timestamp) type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, EndianPolicy policy, Timestamp value) {
        try {
            CodecUtils.int64Type(datagram, offset, policy, value.getTime());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding times(timestamp) type.", (Throwable)e);
        }
    }

    @Override
    public Timestamp decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Timestamp value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), policy, value);
    }
}

