/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;

public class DynamicByteArray {
    protected byte[] bytes;
    protected int size;

    public DynamicByteArray() {
        this.bytes = new byte[16];
        this.size = 0;
    }

    public DynamicByteArray(int capacity) {
        this.bytes = new byte[capacity];
        this.size = capacity;
    }

    public void write(int b) {
        if (this.size == this.bytes.length) {
            this.bytes = Arrays.copyOf(this.bytes, this.bytes.length * 2);
        }
        this.bytes[this.size++] = (byte)b;
    }

    public void write(int b, int offset) {
        if (offset >= this.size) {
            this.size = offset + 1;
        }
        if (this.size == this.bytes.length) {
            this.bytes = Arrays.copyOf(this.bytes, this.bytes.length * 2);
        }
        this.bytes[offset] = (byte)b;
    }

    public int read(int offset) {
        if (offset >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[offset] & 0xFF;
    }

    public int size() {
        return this.size;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.size);
    }
}

