/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Int64ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class Int64ArrayCodec
implements Codec<long[]> {
    public long[] decode(byte[] bytes, int offset, int length, EndianPolicy policy) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToLong(i -> CodecUtils.int64Type(bytes, o + i * 8, policy)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, EndianPolicy policy, long[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int64Type(bytes, o + i * 8, policy, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int32 array type.", (Throwable)e);
        }
    }

    @Override
    public long[] decode(CodecContext context, byte[] bytes) {
        Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), type.length(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, long[] value) {
        Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), type.length(), policy, value);
    }

    public class CollectionCodec
    implements Codec<Collection<Long>> {
        @Override
        public Collection<Long> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(Int64ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Long> collection) {
            Int64ArrayCodec.this.encode(context, bytes, collection.stream().mapToLong(Long::longValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Long[]> {
        @Override
        public Long[] decode(CodecContext context, byte[] bytes) {
            return (Long[])LongStream.of(Int64ArrayCodec.this.decode(context, bytes)).mapToObj(Long::valueOf).toArray(Long[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Long[] values) {
            long[] longs = Stream.of(values).mapToLong(i -> i).toArray();
            Int64ArrayCodec.this.encode(context, bytes, longs);
        }
    }
}

