/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.FixedLength;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;

public class Reference {
    ReferenceType referenceType;
    EndianPolicy endianPolicy;
    Boolean decodingIgnore;
    Boolean encodingIgnore;
    Class<?> protocolClass;
    ConstructorType constructorType;
    FixedLength enableFixedLength;
    Field field;
    Annotation dataTypeAnnotation;
    ProtocolType protocolType;
    Class<? extends Function> decodingFormulaClass;
    Class<? extends Function> encodingFormulaClass;
    Function decodingFormula;
    Function decodingLambda;
    Function encodingFormula;
    Function encodingLambda;
    Function<byte[], ?> decoder;
    BiConsumer<byte[], ? super Object> encoder;
    Integer byteOffset;
    Integer bitOffset;
    Integer size;
    Integer length;
    ThreadLocal<Object> value;

    public void decode(byte[] bytes) {
        Object value = this.decoder.apply(bytes);
        this.setValue(value);
    }

    public void encode(byte[] bytes) {
        this.encoder.accept(bytes, this.getValue().get());
    }

    public Object newInstance() {
        try {
            Object object = this.protocolClass.newInstance();
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), (Throwable)e);
        }
    }

    public Object newInstance(Reference[] references) {
        Class[] types = (Class[])Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(Reference::getField).map(Field::getType).toArray(Class[]::new);
        try {
            Constructor<?> constructor = this.protocolClass.getConstructor(types);
            Object[] args = Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(r -> r.getValue().get()).toArray();
            Object object = constructor.newInstance(args);
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), (Throwable)e);
        }
    }

    public void setField(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        Field field = reference.getField();
        if (this.value.get() != null) {
            try {
                field.set(this.value.get(), reference.getValue().get());
            }
            catch (IllegalAccessException e) {
                throw new DecodingException(String.format("Fail decoding the field %s of class %s", field, this.protocolClass.getName()), (Throwable)e);
            }
        }
    }

    public Object parse(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (this.field == null) {
                return object;
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new EncodingException(String.format("Fail decoding the field %s of class %s", this.field, this.protocolClass.getName()), (Throwable)e);
        }
    }

    public void clear() {
        this.value.remove();
    }

    public void setValue(Object value) {
        this.value.set(value);
    }

    public boolean equals(Object other) {
        if (other instanceof Reference && this.referenceType == ReferenceType.CLASS && ((Reference)other).referenceType == ReferenceType.CLASS) {
            return this.protocolClass == ((Reference)other).protocolClass;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.referenceType == ReferenceType.CLASS) {
            return this.protocolClass.hashCode();
        }
        return super.hashCode();
    }

    private static Boolean $default$decodingIgnore() {
        return false;
    }

    private static Boolean $default$encodingIgnore() {
        return false;
    }

    private static ThreadLocal<Object> $default$value() {
        return new ThreadLocal<Object>();
    }

    public static ReferenceBuilder builder() {
        return new ReferenceBuilder();
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodingIgnore() {
        return this.decodingIgnore;
    }

    public Boolean getEncodingIgnore() {
        return this.encodingIgnore;
    }

    public Class<?> getProtocolClass() {
        return this.protocolClass;
    }

    public ConstructorType getConstructorType() {
        return this.constructorType;
    }

    public FixedLength getEnableFixedLength() {
        return this.enableFixedLength;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getDataTypeAnnotation() {
        return this.dataTypeAnnotation;
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public Class<? extends Function> getDecodingFormulaClass() {
        return this.decodingFormulaClass;
    }

    public Class<? extends Function> getEncodingFormulaClass() {
        return this.encodingFormulaClass;
    }

    public Function getDecodingFormula() {
        return this.decodingFormula;
    }

    public Function getDecodingLambda() {
        return this.decodingLambda;
    }

    public Function getEncodingFormula() {
        return this.encodingFormula;
    }

    public Function getEncodingLambda() {
        return this.encodingLambda;
    }

    public Function<byte[], ?> getDecoder() {
        return this.decoder;
    }

    public BiConsumer<byte[], ? super Object> getEncoder() {
        return this.encoder;
    }

    public Integer getByteOffset() {
        return this.byteOffset;
    }

    public Integer getBitOffset() {
        return this.bitOffset;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getLength() {
        return this.length;
    }

    public ThreadLocal<Object> getValue() {
        return this.value;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodingIgnore(Boolean decodingIgnore) {
        this.decodingIgnore = decodingIgnore;
    }

    public void setEncodingIgnore(Boolean encodingIgnore) {
        this.encodingIgnore = encodingIgnore;
    }

    public void setProtocolClass(Class<?> protocolClass) {
        this.protocolClass = protocolClass;
    }

    public void setConstructorType(ConstructorType constructorType) {
        this.constructorType = constructorType;
    }

    public void setEnableFixedLength(FixedLength enableFixedLength) {
        this.enableFixedLength = enableFixedLength;
    }

    public void setDataTypeAnnotation(Annotation dataTypeAnnotation) {
        this.dataTypeAnnotation = dataTypeAnnotation;
    }

    public void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public void setDecodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
        this.decodingFormulaClass = decodingFormulaClass;
    }

    public void setEncodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
        this.encodingFormulaClass = encodingFormulaClass;
    }

    public void setDecodingFormula(Function decodingFormula) {
        this.decodingFormula = decodingFormula;
    }

    public void setDecodingLambda(Function decodingLambda) {
        this.decodingLambda = decodingLambda;
    }

    public void setEncodingFormula(Function encodingFormula) {
        this.encodingFormula = encodingFormula;
    }

    public void setEncodingLambda(Function encodingLambda) {
        this.encodingLambda = encodingLambda;
    }

    public void setDecoder(Function<byte[], ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(BiConsumer<byte[], ? super Object> encoder) {
        this.encoder = encoder;
    }

    public void setByteOffset(Integer byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setBitOffset(Integer bitOffset) {
        this.bitOffset = bitOffset;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String toString() {
        return "Reference(referenceType=" + (Object)((Object)this.getReferenceType()) + ", endianPolicy=" + (Object)((Object)this.getEndianPolicy()) + ", decodingIgnore=" + this.getDecodingIgnore() + ", encodingIgnore=" + this.getEncodingIgnore() + ", protocolClass=" + this.getProtocolClass() + ", constructorType=" + (Object)((Object)this.getConstructorType()) + ", enableFixedLength=" + this.getEnableFixedLength() + ", field=" + this.getField() + ", dataTypeAnnotation=" + this.getDataTypeAnnotation() + ", protocolType=" + this.getProtocolType() + ", decodingFormulaClass=" + this.getDecodingFormulaClass() + ", encodingFormulaClass=" + this.getEncodingFormulaClass() + ", decodingFormula=" + this.getDecodingFormula() + ", decodingLambda=" + this.getDecodingLambda() + ", encodingFormula=" + this.getEncodingFormula() + ", encodingLambda=" + this.getEncodingLambda() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ", byteOffset=" + this.getByteOffset() + ", bitOffset=" + this.getBitOffset() + ", size=" + this.getSize() + ", length=" + this.getLength() + ", value=" + this.getValue() + ")";
    }

    public Reference() {
        this.decodingIgnore = Reference.$default$decodingIgnore();
        this.encodingIgnore = Reference.$default$encodingIgnore();
        this.value = Reference.$default$value();
    }

    public Reference(ReferenceType referenceType, EndianPolicy endianPolicy, Boolean decodingIgnore, Boolean encodingIgnore, Class<?> protocolClass, ConstructorType constructorType, FixedLength enableFixedLength, Field field, Annotation dataTypeAnnotation, ProtocolType protocolType, Class<? extends Function> decodingFormulaClass, Class<? extends Function> encodingFormulaClass, Function decodingFormula, Function decodingLambda, Function encodingFormula, Function encodingLambda, Function<byte[], ?> decoder, BiConsumer<byte[], ? super Object> encoder, Integer byteOffset, Integer bitOffset, Integer size, Integer length, ThreadLocal<Object> value) {
        this.referenceType = referenceType;
        this.endianPolicy = endianPolicy;
        this.decodingIgnore = decodingIgnore;
        this.encodingIgnore = encodingIgnore;
        this.protocolClass = protocolClass;
        this.constructorType = constructorType;
        this.enableFixedLength = enableFixedLength;
        this.field = field;
        this.dataTypeAnnotation = dataTypeAnnotation;
        this.protocolType = protocolType;
        this.decodingFormulaClass = decodingFormulaClass;
        this.encodingFormulaClass = encodingFormulaClass;
        this.decodingFormula = decodingFormula;
        this.decodingLambda = decodingLambda;
        this.encodingFormula = encodingFormula;
        this.encodingLambda = encodingLambda;
        this.decoder = decoder;
        this.encoder = encoder;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.size = size;
        this.length = length;
        this.value = value;
    }

    public Reference withReferenceType(ReferenceType referenceType) {
        return this.referenceType == referenceType ? this : new Reference(referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEndianPolicy(EndianPolicy endianPolicy) {
        return this.endianPolicy == endianPolicy ? this : new Reference(this.referenceType, endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodingIgnore(Boolean decodingIgnore) {
        return this.decodingIgnore == decodingIgnore ? this : new Reference(this.referenceType, this.endianPolicy, decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodingIgnore(Boolean encodingIgnore) {
        return this.encodingIgnore == encodingIgnore ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withProtocolClass(Class<?> protocolClass) {
        return this.protocolClass == protocolClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withConstructorType(ConstructorType constructorType) {
        return this.constructorType == constructorType ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableFixedLength(FixedLength enableFixedLength) {
        return this.enableFixedLength == enableFixedLength ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withField(Field field) {
        return this.field == field ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDataTypeAnnotation(Annotation dataTypeAnnotation) {
        return this.dataTypeAnnotation == dataTypeAnnotation ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withProtocolType(ProtocolType protocolType) {
        return this.protocolType == protocolType ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
        return this.decodingFormulaClass == decodingFormulaClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
        return this.encodingFormulaClass == encodingFormulaClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodingFormula(Function decodingFormula) {
        return this.decodingFormula == decodingFormula ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodingLambda(Function decodingLambda) {
        return this.decodingLambda == decodingLambda ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodingFormula(Function encodingFormula) {
        return this.encodingFormula == encodingFormula ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodingLambda(Function encodingLambda) {
        return this.encodingLambda == encodingLambda ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecoder(Function<byte[], ?> decoder) {
        return this.decoder == decoder ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncoder(BiConsumer<byte[], ? super Object> encoder) {
        return this.encoder == encoder ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withByteOffset(Integer byteOffset) {
        return this.byteOffset == byteOffset ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withBitOffset(Integer bitOffset) {
        return this.bitOffset == bitOffset ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, bitOffset, this.size, this.length, this.value);
    }

    public Reference withSize(Integer size) {
        return this.size == size ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, size, this.length, this.value);
    }

    public Reference withLength(Integer length) {
        return this.length == length ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, length, this.value);
    }

    public Reference withValue(ThreadLocal<Object> value) {
        return this.value == value ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, value);
    }

    public static class ReferenceBuilder {
        private ReferenceType referenceType;
        private EndianPolicy endianPolicy;
        private boolean decodingIgnore$set;
        private Boolean decodingIgnore$value;
        private boolean encodingIgnore$set;
        private Boolean encodingIgnore$value;
        private Class<?> protocolClass;
        private ConstructorType constructorType;
        private FixedLength enableFixedLength;
        private Field field;
        private Annotation dataTypeAnnotation;
        private ProtocolType protocolType;
        private Class<? extends Function> decodingFormulaClass;
        private Class<? extends Function> encodingFormulaClass;
        private Function decodingFormula;
        private Function decodingLambda;
        private Function encodingFormula;
        private Function encodingLambda;
        private Function<byte[], ?> decoder;
        private BiConsumer<byte[], ? super Object> encoder;
        private Integer byteOffset;
        private Integer bitOffset;
        private Integer size;
        private Integer length;
        private boolean value$set;
        private ThreadLocal<Object> value$value;

        ReferenceBuilder() {
        }

        public ReferenceBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public ReferenceBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public ReferenceBuilder decodingIgnore(Boolean decodingIgnore) {
            this.decodingIgnore$value = decodingIgnore;
            this.decodingIgnore$set = true;
            return this;
        }

        public ReferenceBuilder encodingIgnore(Boolean encodingIgnore) {
            this.encodingIgnore$value = encodingIgnore;
            this.encodingIgnore$set = true;
            return this;
        }

        public ReferenceBuilder protocolClass(Class<?> protocolClass) {
            this.protocolClass = protocolClass;
            return this;
        }

        public ReferenceBuilder constructorType(ConstructorType constructorType) {
            this.constructorType = constructorType;
            return this;
        }

        public ReferenceBuilder enableFixedLength(FixedLength enableFixedLength) {
            this.enableFixedLength = enableFixedLength;
            return this;
        }

        public ReferenceBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public ReferenceBuilder dataTypeAnnotation(Annotation dataTypeAnnotation) {
            this.dataTypeAnnotation = dataTypeAnnotation;
            return this;
        }

        public ReferenceBuilder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public ReferenceBuilder decodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
            this.decodingFormulaClass = decodingFormulaClass;
            return this;
        }

        public ReferenceBuilder encodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
            this.encodingFormulaClass = encodingFormulaClass;
            return this;
        }

        public ReferenceBuilder decodingFormula(Function decodingFormula) {
            this.decodingFormula = decodingFormula;
            return this;
        }

        public ReferenceBuilder decodingLambda(Function decodingLambda) {
            this.decodingLambda = decodingLambda;
            return this;
        }

        public ReferenceBuilder encodingFormula(Function encodingFormula) {
            this.encodingFormula = encodingFormula;
            return this;
        }

        public ReferenceBuilder encodingLambda(Function encodingLambda) {
            this.encodingLambda = encodingLambda;
            return this;
        }

        public ReferenceBuilder decoder(Function<byte[], ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public ReferenceBuilder encoder(BiConsumer<byte[], ? super Object> encoder) {
            this.encoder = encoder;
            return this;
        }

        public ReferenceBuilder byteOffset(Integer byteOffset) {
            this.byteOffset = byteOffset;
            return this;
        }

        public ReferenceBuilder bitOffset(Integer bitOffset) {
            this.bitOffset = bitOffset;
            return this;
        }

        public ReferenceBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public ReferenceBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public ReferenceBuilder value(ThreadLocal<Object> value) {
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        public Reference build() {
            Boolean decodingIgnore$value = this.decodingIgnore$value;
            if (!this.decodingIgnore$set) {
                decodingIgnore$value = Reference.$default$decodingIgnore();
            }
            Boolean encodingIgnore$value = this.encodingIgnore$value;
            if (!this.encodingIgnore$set) {
                encodingIgnore$value = Reference.$default$encodingIgnore();
            }
            ThreadLocal value$value = this.value$value;
            if (!this.value$set) {
                value$value = Reference.$default$value();
            }
            return new Reference(this.referenceType, this.endianPolicy, decodingIgnore$value, encodingIgnore$value, this.protocolClass, this.constructorType, this.enableFixedLength, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, value$value);
        }

        public String toString() {
            return "Reference.ReferenceBuilder(referenceType=" + (Object)((Object)this.referenceType) + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodingIgnore$value=" + this.decodingIgnore$value + ", encodingIgnore$value=" + this.encodingIgnore$value + ", protocolClass=" + this.protocolClass + ", constructorType=" + (Object)((Object)this.constructorType) + ", enableFixedLength=" + this.enableFixedLength + ", field=" + this.field + ", dataTypeAnnotation=" + this.dataTypeAnnotation + ", protocolType=" + this.protocolType + ", decodingFormulaClass=" + this.decodingFormulaClass + ", encodingFormulaClass=" + this.encodingFormulaClass + ", decodingFormula=" + this.decodingFormula + ", decodingLambda=" + this.decodingLambda + ", encodingFormula=" + this.encodingFormula + ", encodingLambda=" + this.encodingLambda + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", size=" + this.size + ", length=" + this.length + ", value$value=" + this.value$value + ")";
        }
    }

    public static enum ConstructorType {
        NO_ARGS,
        ALL_ARGS;

    }

    public static enum ReferenceType {
        CLASS,
        FIELD,
        INVALID;

    }
}

