/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.indunet.fastproto.annotation.BinaryType;
import org.indunet.fastproto.annotation.BoolArrayType;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.annotation.CharType;
import org.indunet.fastproto.annotation.DoubleArrayType;
import org.indunet.fastproto.annotation.DoubleType;
import org.indunet.fastproto.annotation.EnumType;
import org.indunet.fastproto.annotation.FloatArrayType;
import org.indunet.fastproto.annotation.FloatType;
import org.indunet.fastproto.annotation.Int16ArrayType;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.annotation.Int32ArrayType;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.annotation.Int64ArrayType;
import org.indunet.fastproto.annotation.Int64Type;
import org.indunet.fastproto.annotation.Int8ArrayType;
import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.annotation.StringType;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.annotation.UInt16ArrayType;
import org.indunet.fastproto.annotation.UInt16Type;
import org.indunet.fastproto.annotation.UInt32ArrayType;
import org.indunet.fastproto.annotation.UInt32Type;
import org.indunet.fastproto.annotation.UInt64ArrayType;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.annotation.UInt8ArrayType;
import org.indunet.fastproto.annotation.UInt8Type;
import org.indunet.fastproto.codec.AsciiCodec;
import org.indunet.fastproto.codec.BinaryCodec;
import org.indunet.fastproto.codec.BoolArrayCodec;
import org.indunet.fastproto.codec.BoolCodec;
import org.indunet.fastproto.codec.ByteCodec;
import org.indunet.fastproto.codec.CalendarCodec;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.codec.DateCodec;
import org.indunet.fastproto.codec.DoubleArrayCodec;
import org.indunet.fastproto.codec.DoubleCodec;
import org.indunet.fastproto.codec.EnumCodec;
import org.indunet.fastproto.codec.FloatArrayCodec;
import org.indunet.fastproto.codec.FloatCodec;
import org.indunet.fastproto.codec.InstantCodec;
import org.indunet.fastproto.codec.Int16ArrayCodec;
import org.indunet.fastproto.codec.Int16Codec;
import org.indunet.fastproto.codec.Int32ArrayCodec;
import org.indunet.fastproto.codec.Int32Codec;
import org.indunet.fastproto.codec.Int64ArrayCodec;
import org.indunet.fastproto.codec.Int64Codec;
import org.indunet.fastproto.codec.Int8ArrayCodec;
import org.indunet.fastproto.codec.Int8Codec;
import org.indunet.fastproto.codec.ShortArrayCodec;
import org.indunet.fastproto.codec.ShortCodec;
import org.indunet.fastproto.codec.StringBufferCodec;
import org.indunet.fastproto.codec.StringBuilderCodec;
import org.indunet.fastproto.codec.StringCodec;
import org.indunet.fastproto.codec.TimestampCodec;
import org.indunet.fastproto.codec.UInt16ArrayCodec;
import org.indunet.fastproto.codec.UInt16Codec;
import org.indunet.fastproto.codec.UInt32ArrayCodec;
import org.indunet.fastproto.codec.UInt32Codec;
import org.indunet.fastproto.codec.UInt64ArrayCodec;
import org.indunet.fastproto.codec.UInt64Codec;
import org.indunet.fastproto.codec.UInt8ArrayCodec;
import org.indunet.fastproto.codec.UInt8Codec;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.ResolveException;

public class CodecMapper {
    protected static ConcurrentHashMap<Class, Map<Predicate<Type>, Codec>> codecMap = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static boolean isSupported(Type type) {
        return codecMap.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(p -> p.test((Class)type));
    }

    public static Codec getCodec(Class type, Type fieldClass) {
        if (!codecMap.containsKey(type)) {
            throw new CodecException(String.format("%s is not supported.", type.toString()));
        }
        Map<Predicate<Type>, Codec> map = codecMap.get(type);
        return map.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(fieldClass)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new CodecException(String.format("%s cannot be used on %s", type.getSimpleName(), fieldClass)));
    }

    public static <T, R> Function<T, R> getFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, c -> {
            try {
                return (Function)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_FORMULA.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public static Class getDataTypeAnnotationClass(Class fieldType) {
        return codecMap.entrySet().stream().filter(e -> ((Map)e.getValue()).keySet().stream().anyMatch(p -> p.test(fieldType))).map(Map.Entry::getKey).findAny().orElseThrow(() -> new ResolveException(String.format("%s is not supported", fieldType.getName())));
    }

    public static Function<byte[], ?> getDecoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).findAny().get();
            Function<byte[], Object> func = bytes -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).decode(context, (byte[])bytes);
            return func.andThen(CodecMapper.getFormula(clazz));
        }
        return bytes -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), context.getField().getGenericType()).decode(context, (byte[])bytes);
    }

    public static Function<byte[], ?> getDefaultDecoder(CodecContext context, Class type) {
        return bytes -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), type).decode(context, (byte[])bytes);
    }

    public static BiConsumer<byte[], ? super Object> getEncoder(CodecContext context, Class<? extends Function> clazz) {
        if (clazz != null) {
            Type type = Arrays.stream(clazz.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).findAny().get();
            return (bytes, value) -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), (Class)type).encode(context, (byte[])bytes, CodecMapper.getFormula(clazz).apply(value));
        }
        return (bytes, value) -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), context.getField().getGenericType()).encode(context, (byte[])bytes, value);
    }

    public static BiConsumer<byte[], ? super Object> getDefaultEncoder(CodecContext context, Class type) {
        return (bytes, value) -> CodecMapper.getCodec(context.getDataTypeAnnotation().annotationType(), type).encode(context, (byte[])bytes, value);
    }

    static {
        codecMap.put(Int8Type.class, new HashMap());
        codecMap.put(Int8ArrayType.class, new HashMap());
        codecMap.put(BinaryType.class, new HashMap());
        codecMap.put(Int16Type.class, new HashMap());
        codecMap.put(Int16ArrayType.class, new HashMap());
        codecMap.put(Int32Type.class, new HashMap());
        codecMap.put(Int32ArrayType.class, new HashMap());
        codecMap.put(Int64Type.class, new HashMap());
        codecMap.put(Int64ArrayType.class, new HashMap());
        codecMap.put(UInt8Type.class, new HashMap());
        codecMap.put(UInt8ArrayType.class, new HashMap());
        codecMap.put(UInt16Type.class, new HashMap());
        codecMap.put(UInt16ArrayType.class, new HashMap());
        codecMap.put(UInt32Type.class, new HashMap());
        codecMap.put(UInt32ArrayType.class, new HashMap());
        codecMap.put(UInt64Type.class, new HashMap());
        codecMap.put(UInt64ArrayType.class, new HashMap());
        codecMap.put(FloatType.class, new HashMap());
        codecMap.put(FloatArrayType.class, new HashMap());
        codecMap.put(DoubleType.class, new HashMap());
        codecMap.put(DoubleArrayType.class, new HashMap());
        codecMap.put(BoolType.class, new HashMap());
        codecMap.put(BoolArrayType.class, new HashMap());
        codecMap.put(CharType.class, new HashMap());
        codecMap.put(TimeType.class, new HashMap());
        codecMap.put(EnumType.class, new HashMap());
        codecMap.put(StringType.class, new HashMap());
        BiFunction<Type, Class, Boolean> collectionType = (t, c) -> t instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType()) && ((ParameterizedType)t).getActualTypeArguments()[0].equals(c);
        ByteCodec byteCodec = new ByteCodec();
        BinaryCodec binaryCodec = new BinaryCodec();
        codecMap.get(Int8Type.class).put(c -> c.equals(Byte.TYPE) || c.equals(Byte.class), byteCodec);
        codecMap.get(BinaryType.class).put(c -> c.equals(byte[].class), binaryCodec);
        codecMap.get(BinaryType.class).put(c -> c.equals(Byte[].class), binaryCodec.new BinaryCodec.WrapperCodec());
        codecMap.get(BinaryType.class).put(t -> (Boolean)collectionType.apply((Type)t, Byte.class), binaryCodec.new BinaryCodec.CollectionCodec());
        Int8Codec int8Codec = new Int8Codec();
        Int8ArrayCodec int8ArrayCodec = new Int8ArrayCodec();
        codecMap.get(Int8Type.class).put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), int8Codec);
        codecMap.get(Int8ArrayType.class).put(c -> c.equals(byte[].class), binaryCodec);
        codecMap.get(Int8ArrayType.class).put(c -> c.equals(int[].class), int8ArrayCodec);
        codecMap.get(Int8ArrayType.class).put(c -> c.equals(Integer[].class), int8ArrayCodec.new Int8ArrayCodec.WrapperCodec());
        codecMap.get(Int8ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), int8ArrayCodec.new Int8ArrayCodec.CollectionCodec());
        ShortCodec shortCodec = new ShortCodec();
        Int16Codec int16Codec = new Int16Codec();
        ShortArrayCodec shortArrayCodec = new ShortArrayCodec();
        Int16ArrayCodec int16ArrayCodec = new Int16ArrayCodec();
        codecMap.get(Int16Type.class).put(c -> c.equals(Short.TYPE) || c.equals(Short.class), shortCodec);
        codecMap.get(Int16Type.class).put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), int16Codec);
        codecMap.get(Int16ArrayType.class).put(c -> c.equals(short[].class), shortArrayCodec);
        codecMap.get(Int16ArrayType.class).put(c -> c.equals(int[].class), int16ArrayCodec);
        codecMap.get(Int16ArrayType.class).put(c -> c.equals(Integer[].class), int16ArrayCodec.new Int16ArrayCodec.WrapperCodec());
        codecMap.get(Int16ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), int16ArrayCodec.new Int16ArrayCodec.CollectionCodec());
        codecMap.get(Int16ArrayType.class).put(c -> c.equals(Short[].class), shortArrayCodec.new ShortArrayCodec.WrapperCodec());
        codecMap.get(Int16ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Short.class), shortArrayCodec.new ShortArrayCodec.CollectionCodec());
        Int32Codec int32Codec = new Int32Codec();
        Int32ArrayCodec int32ArrayCodec = new Int32ArrayCodec();
        codecMap.get(Int32Type.class).put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), int32Codec);
        codecMap.get(Int32ArrayType.class).put(c -> c.equals(int[].class), int32ArrayCodec);
        codecMap.get(Int32ArrayType.class).put(c -> c.equals(Integer[].class), int32ArrayCodec.new Int32ArrayCodec.WrapperCodec());
        codecMap.get(Int32ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), int32ArrayCodec.new Int32ArrayCodec.CollectionCodec());
        Int64Codec int64Codec = new Int64Codec();
        Int64ArrayCodec int64ArrayCodec = new Int64ArrayCodec();
        codecMap.get(Int64Type.class).put(c -> c.equals(Long.TYPE) || c.equals(Long.class), int64Codec);
        codecMap.get(Int64ArrayType.class).put(c -> c.equals(long[].class), int64ArrayCodec);
        codecMap.get(Int64ArrayType.class).put(c -> c.equals(Long[].class), int64ArrayCodec.new Int64ArrayCodec.WrapperCodec());
        codecMap.get(Int64ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Long.class), int64ArrayCodec.new Int64ArrayCodec.CollectionCodec());
        UInt8Codec uint8Codec = new UInt8Codec();
        UInt8ArrayCodec uint8ArrayCodec = new UInt8ArrayCodec();
        codecMap.get(UInt8Type.class).put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), uint8Codec);
        codecMap.get(UInt8ArrayType.class).put(c -> c.equals(int[].class), uint8ArrayCodec);
        codecMap.get(UInt8ArrayType.class).put(c -> c.equals(Integer[].class), uint8ArrayCodec.new UInt8ArrayCodec.WrapperCodec());
        codecMap.get(UInt8ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), uint8ArrayCodec.new UInt8ArrayCodec.CollectionCodec());
        UInt16Codec uint16Codec = new UInt16Codec();
        UInt16ArrayCodec uint16ArrayCodec = new UInt16ArrayCodec();
        codecMap.get(UInt16Type.class).put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), uint16Codec);
        codecMap.get(UInt16ArrayType.class).put(c -> c.equals(int[].class), uint16ArrayCodec);
        codecMap.get(UInt16ArrayType.class).put(c -> c.equals(Integer[].class), uint16ArrayCodec.new UInt16ArrayCodec.WrapperCodec());
        codecMap.get(UInt16ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), uint16ArrayCodec.new UInt16ArrayCodec.CollectionCodec());
        UInt32Codec uint32Codec = new UInt32Codec();
        UInt32ArrayCodec uint32ArrayCodec = new UInt32ArrayCodec();
        codecMap.get(UInt32Type.class).put(c -> c.equals(Long.TYPE) || c.equals(Long.class), uint32Codec);
        codecMap.get(UInt32ArrayType.class).put(c -> c.equals(long[].class), uint32ArrayCodec);
        codecMap.get(UInt32ArrayType.class).put(c -> c.equals(Long[].class), uint32ArrayCodec.new UInt32ArrayCodec.WrapperCodec());
        codecMap.get(UInt32ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Long.class), uint32ArrayCodec.new UInt32ArrayCodec.CollectionCodec());
        UInt64Codec uint64Codec = new UInt64Codec();
        UInt64ArrayCodec uint64ArrayCodec = new UInt64ArrayCodec();
        codecMap.get(UInt64Type.class).put(c -> c.equals(BigInteger.class), uint64Codec);
        codecMap.get(UInt64ArrayType.class).put(c -> c.equals(BigInteger[].class), uint64ArrayCodec);
        codecMap.get(UInt64ArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, BigInteger.class), uint64ArrayCodec.new UInt64ArrayCodec.CollectionCodec());
        FloatCodec floatCodec = new FloatCodec();
        FloatArrayCodec floatArrayCodec = new FloatArrayCodec();
        codecMap.get(FloatType.class).put(c -> c.equals(Float.TYPE) || c.equals(Float.class), floatCodec);
        codecMap.get(FloatArrayType.class).put(c -> c.equals(float[].class), floatArrayCodec);
        codecMap.get(FloatArrayType.class).put(c -> c.equals(Float[].class), floatArrayCodec.new FloatArrayCodec.WrapperCodec());
        codecMap.get(FloatArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Float.class), floatArrayCodec.new FloatArrayCodec.CollectionCodec());
        DoubleCodec doubleCodec = new DoubleCodec();
        DoubleArrayCodec doubleArrayCodec = new DoubleArrayCodec();
        codecMap.get(DoubleType.class).put(c -> c.equals(Double.TYPE) || c.equals(Double.class), doubleCodec);
        codecMap.get(DoubleArrayType.class).put(c -> c.equals(double[].class), doubleArrayCodec);
        codecMap.get(DoubleArrayType.class).put(c -> c.equals(Double[].class), doubleArrayCodec.new DoubleArrayCodec.WrapperCodec());
        codecMap.get(DoubleArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Double.class), doubleArrayCodec.new DoubleArrayCodec.CollectionCodec());
        BoolCodec boolCodec = new BoolCodec();
        BoolArrayCodec boolArrayCodec = new BoolArrayCodec();
        codecMap.get(BoolType.class).put(c -> c.equals(Boolean.TYPE) || c.equals(Boolean.class), boolCodec);
        codecMap.get(BoolArrayType.class).put(c -> c.equals(boolean[].class), boolArrayCodec);
        codecMap.get(BoolArrayType.class).put(c -> c.equals(Boolean[].class), boolArrayCodec.new BoolArrayCodec.WrapperCodec());
        codecMap.get(BoolArrayType.class).put(t -> (Boolean)collectionType.apply((Type)t, Boolean.class), boolArrayCodec.new BoolArrayCodec.CollectionCodec());
        AsciiCodec charCodec = new AsciiCodec();
        codecMap.get(CharType.class).put(c -> c.equals(Character.TYPE) || c.equals(Character.class), charCodec);
        DateCodec dateCodec = new DateCodec();
        TimestampCodec timestampCodec = new TimestampCodec();
        CalendarCodec calendarCodec = new CalendarCodec();
        InstantCodec instantCodec = new InstantCodec();
        codecMap.get(TimeType.class).put(c -> c.equals(Date.class), dateCodec);
        codecMap.get(TimeType.class).put(c -> c.equals(Timestamp.class), timestampCodec);
        codecMap.get(TimeType.class).put(c -> c.equals(Calendar.class), calendarCodec);
        codecMap.get(TimeType.class).put(c -> c.equals(Instant.class), instantCodec);
        StringCodec stringCodec = new StringCodec();
        StringBufferCodec stringBufferCodec = new StringBufferCodec();
        StringBuilderCodec stringBuilderCodec = new StringBuilderCodec();
        codecMap.get(StringType.class).put(c -> c.equals(String.class), stringCodec);
        codecMap.get(StringType.class).put(c -> c.equals(StringBuffer.class), stringBufferCodec);
        codecMap.get(StringType.class).put(c -> c.equals(StringBuilder.class), stringBuilderCodec);
        EnumCodec enumCodec = new EnumCodec();
        codecMap.get(EnumType.class).put(t -> Enum.class.isAssignableFrom((Class)t), enumCodec);
    }
}

