/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.math.BigInteger;
import java.util.stream.IntStream;
import org.indunet.fastproto.DynamicByteBuffer;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.util.CodecUtils;

class Encoder {
    DynamicByteBuffer byteBuffer = new DynamicByteBuffer();
    protected EndianPolicy endianPolicy = EndianPolicy.LITTLE;

    Encoder() {
    }

    public Encoder length(int length) {
        this.byteBuffer.setCapacity(length);
        return this;
    }

    public Encoder defaultEndian(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
        return this;
    }

    public Encoder boolType(int byteOffset, int bitOffset, boolean value) {
        CodecUtils.boolType(this.byteBuffer, byteOffset, bitOffset, value);
        return this;
    }

    public Encoder uint8Type(int offset, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint8Type(this.byteBuffer, offset + i, values[i]));
        return this;
    }

    public Encoder uint16Type(int offset, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint16Type(this.byteBuffer, offset + i * 2, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder uint16Type(int offset, EndianPolicy endianPolicy, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint16Type(this.byteBuffer, offset + i * 2, endianPolicy, values[i]));
        return this;
    }

    public Encoder uint32Type(int offset, long ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint32Type(this.byteBuffer, offset + i * 4, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder uint32Type(int offset, EndianPolicy endianPolicy, long ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint32Type(this.byteBuffer, offset + i * 4, endianPolicy, values[i]));
        return this;
    }

    public Encoder uint64Type(int offset, BigInteger ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint64Type(this.byteBuffer, offset + i * 8, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder uint64Type(int offset, EndianPolicy endianPolicy, BigInteger ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.uint64Type(this.byteBuffer, offset + i * 8, endianPolicy, values[i]));
        return this;
    }

    public Encoder int8Type(int offset, byte ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.byteType(this.byteBuffer, offset + i, values[i]));
        return this;
    }

    public Encoder int8Type(int offset, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int8Type(this.byteBuffer, offset + i, values[i]));
        return this;
    }

    public Encoder int16Type(int offset, short ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int16Type(this.byteBuffer, offset + i * 2, this.endianPolicy, (int)values[i]));
        return this;
    }

    public Encoder int16Type(int offset, EndianPolicy endianPolicy, short ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int16Type(this.byteBuffer, offset + i * 2, endianPolicy, (int)values[i]));
        return this;
    }

    public Encoder int16Type(int offset, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int16Type(this.byteBuffer, offset + i * 2, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder int16Type(int offset, EndianPolicy endianPolicy, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int16Type(this.byteBuffer, offset + i * 2, endianPolicy, values[i]));
        return this;
    }

    public Encoder int32Type(int offset, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int32Type(this.byteBuffer, offset + i * 4, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder int32Type(int offset, EndianPolicy endianPolicy, int ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int32Type(this.byteBuffer, offset + i * 4, endianPolicy, values[i]));
        return this;
    }

    public Encoder int64Type(int offset, long ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int64Type(this.byteBuffer, offset + i * 8, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder int64Type(int offset, EndianPolicy endianPolicy, long ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.int64Type(this.byteBuffer, offset + i * 8, endianPolicy, values[i]));
        return this;
    }

    public Encoder floatType(int offset, float ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.floatType(this.byteBuffer, offset + i * 4, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder floatType(int offset, EndianPolicy endianPolicy, float ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.floatType(this.byteBuffer, offset + i * 4, endianPolicy, values[i]));
        return this;
    }

    public Encoder doubleType(int offset, double ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.doubleType(this.byteBuffer, offset + i * 8, this.endianPolicy, values[i]));
        return this;
    }

    public Encoder doubleType(int offset, EndianPolicy endianPolicy, double ... values) {
        IntStream.range(0, values.length).forEach(i -> CodecUtils.doubleType(this.byteBuffer, offset + i * 8, endianPolicy, values[i]));
        return this;
    }

    public byte[] get() {
        return this.byteBuffer.getBytes();
    }
}

