/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.Decoder;
import org.indunet.fastproto.Encoder;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Resolver;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class FastProto {
    public static <T> T parse(@NonNull byte[] bytes, @NonNull Class<T> clazz) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Graph graph = Resolver.resolve(clazz);
        PipelineContext context = PipelineContext.builder().bytes(bytes).clazz(clazz).graph(graph).build();
        Pipeline.getDecodeFlow().process(context);
        return context.getObject(clazz);
    }

    public static Decoder parse(byte[] bytes) {
        return new Decoder(bytes);
    }

    public static byte[] toBytes(Object object) {
        Graph graph = Resolver.resolve(object.getClass());
        PipelineContext context = PipelineContext.builder().object(object).clazz(object.getClass()).graph(graph).build();
        Pipeline.getEncodeFlow().process(context);
        return context.getBytes();
    }

    public static byte[] toBytes(Object object, int length) {
        byte[] bytes = new byte[length];
        FastProto.toBytes(object, bytes);
        return bytes;
    }

    public static void toBytes(Object object, byte[] buffer) {
        Graph graph = Resolver.resolve(object.getClass());
        PipelineContext context = PipelineContext.builder().object(object).clazz(object.getClass()).bytes(buffer).graph(graph).build();
        Pipeline.getEncodeFlow().process(context);
    }

    public static Encoder toBytes() {
        return new Encoder();
    }
}

