/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Int16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class Int16ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length, EndianPolicy policy) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            return IntStream.range(0, l).map(i -> CodecUtils.int16Type(bytes, o + i * 2, policy)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int16 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, EndianPolicy policy, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int16Type(bytes, o + i * 2, policy, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int16 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), type.length(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, int[] value) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), type.length(), policy, value);
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(Int16ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Integer> collection) {
            Int16ArrayCodec.this.encode(context, bytes, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(Int16ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            Int16ArrayCodec.this.encode(context, bytes, ints);
        }
    }
}

