/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Int16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class ShortArrayCodec
implements Codec<short[]> {
    public short[] decode(byte[] bytes, int offset, int length, EndianPolicy policy) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            short[] values = new short[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = CodecUtils.shortType(bytes, o + i * 2, policy);
            });
            return values;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding short array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, EndianPolicy policy, short[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.shortType(bytes, o + i * 2, policy, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding short array type.", (Throwable)e);
        }
    }

    @Override
    public short[] decode(CodecContext context, byte[] bytes) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        return this.decode(bytes, type.offset(), type.length(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, short[] value) {
        Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
        EndianPolicy policy = Arrays.stream(type.endian()).findFirst().orElseGet(context::getDefaultEndianPolicy);
        this.encode(bytes, type.offset(), type.length(), policy, value);
    }

    public class CollectionCodec
    implements Codec<Collection<Short>> {
        @Override
        public Collection<Short> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (short b : ShortArrayCodec.this.decode(context, bytes)) {
                    collection.add(b);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Short> collection) {
            short[] ss = new short[collection.size()];
            Short[] values = (Short[])collection.stream().toArray(Short[]::new);
            IntStream.range(0, ss.length).forEach(i -> {
                ss[i] = values[i];
            });
            ShortArrayCodec.this.encode(context, bytes, ss);
        }
    }

    public class WrapperCodec
    implements Codec<Short[]> {
        @Override
        public Short[] decode(CodecContext context, byte[] bytes) {
            short[] shorts = ShortArrayCodec.this.decode(context, bytes);
            Short[] values = new Short[shorts.length];
            IntStream.range(0, shorts.length).forEach(i -> {
                values[i] = shorts[i];
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Short[] values) {
            short[] shorts = new short[values.length];
            IntStream.range(0, shorts.length).forEach(i -> {
                shorts[i] = values[i];
            });
            ShortArrayCodec.this.encode(context, bytes, shorts);
        }
    }
}

