/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.text.MessageFormat;
import java.util.List;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class EncodeFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Graph graph = context.getGraph();
        Object object = context.getObject();
        byte[] bytes = context.getBytes();
        List<Reference> refs = graph.getValidReferences();
        graph.copy(object);
        refs.stream().filter(r -> r.getEncodingIgnore() == false).filter(r -> r.getValue().get() != null).forEach(r -> {
            try {
                r.encode(bytes);
            }
            catch (EncodingException e) {
                throw new EncodingException(MessageFormat.format(CodecError.FAIL_ENCODING_FIELD.getMessage(), r.getField().toString()), (Throwable)e);
            }
        });
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 512L;
    }
}

